/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.panorama.main;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.swdteam.panorama.main.Config;
import com.swdteam.panorama.main.Main;
import com.swdteam.panorama.main.Util;
import com.swdteam.panorama.main.registry.Keybinds;
import com.swdteam.panorama.ui.GuiPanoramaSelector;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3d;

@Mod.EventBusSubscriber(modid="panorama", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class Events {
    public static int WIN_BACK_WIDTH;
    public static int WIN_BACK_HEIGHT;
    public static Map<String, NativeImage[]> images;
    public static Vector3d position;
    static String currentName;
    static NativeImage[] screenshots;
    static boolean takePanorama;
    public static int index;
    public static double backupFov;
    static int timer;

    @SubscribeEvent
    public static void screenshotEvent(TickEvent.ClientTickEvent event) {
        if (Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91075_ != null && Keybinds.SCREENSHOT.m_90857_() && !takePanorama) {
            if (Config.INSTANCE.save_resolution != Main.CaptureResolution.DEFAULT) {
                WIN_BACK_WIDTH = Minecraft.m_91087_().m_91268_().m_85441_();
                WIN_BACK_HEIGHT = Minecraft.m_91087_().m_91268_().m_85442_();
                Minecraft.m_91087_().m_91268_().m_85415_(Minecraft.m_91087_().m_91268_().f_85349_, Config.INSTANCE.save_resolution.res, Config.INSTANCE.save_resolution.res);
            }
            LocalPlayer pe = Minecraft.m_91087_().f_91074_;
            position = new Vector3d(pe.m_20185_(), pe.m_20186_(), pe.m_20189_());
            backupFov = ((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue();
            Minecraft.m_91087_().f_91066_.m_231837_().m_231514_((Object)90);
            currentName = "panorama-" + System.currentTimeMillis() / 100L;
            screenshots = new NativeImage[6];
            takePanorama = true;
            index = 0;
        }
    }

    @SubscribeEvent
    public static void init(RegisterKeyMappingsEvent e) {
        e.register(Keybinds.SCREENSHOT);
    }

    public static void takeScreenshot(Window window, int index) {
        int fromX;
        int dimension;
        NativeImage image = Screenshot.m_92279_((RenderTarget)Minecraft.m_91087_().m_91385_());
        File file = new File("temp/panorama_" + index + ".png");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        int imageWidth = image.m_84982_();
        int imageHeight = image.m_85084_();
        int fromY = 0;
        if (imageWidth > imageHeight) {
            dimension = imageHeight;
            fromX = imageWidth / 2 - dimension / 2;
        } else {
            dimension = imageWidth;
            fromX = imageWidth / 2 - dimension / 2;
        }
        NativeImage image2 = new NativeImage(dimension, dimension, true);
        image.m_85034_(fromX, fromY, dimension, dimension, image2);
        Events.screenshots[index] = image2;
    }

    @SubscribeEvent
    public static void cameraEvent(ViewportEvent.ComputeCameraAngles event) {
        if (takePanorama && index < 6) {
            Facing f = Facing.getIndex(index);
            event.setYaw(f.yaw);
            event.setPitch(f.pitch);
            event.setRoll(0.0f);
        }
    }

    @SubscribeEvent
    public static void fovEvent(ViewportEvent.ComputeFov event) {
        if (takePanorama) {
            event.setFOV(90.0);
        }
    }

    @SubscribeEvent
    public static void blockOverlayEvent(RenderBlockScreenEffectEvent event) {
        if (takePanorama) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderWorldEvent(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (takePanorama) {
            if (timer >= 50) {
                timer = 0;
                if (index < 6) {
                    mc.f_91066_.m_231837_().m_231514_((Object)90);
                    Window window = mc.m_91268_();
                    Events.takeScreenshot(window, index);
                    ++index;
                } else {
                    takePanorama = false;
                    if (Config.INSTANCE.save_resolution != Main.CaptureResolution.DEFAULT) {
                        Minecraft.m_91087_().m_91268_().m_85415_(Minecraft.m_91087_().m_91268_().f_85349_, WIN_BACK_WIDTH, WIN_BACK_HEIGHT);
                    }
                    mc.f_91066_.m_231837_().m_231514_((Object)((int)backupFov));
                    images.put(currentName, screenshots);
                    try {
                        Util.zipFiles(currentName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                ++timer;
            }
        } else {
            timer = 0;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void guiEvent(RenderHandEvent event) {
        if (takePanorama) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void guiEvent(RenderGuiOverlayEvent event) {
        if (takePanorama) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void guiEvent(ScreenEvent.Opening event) {
        if (event.getScreen() instanceof TitleScreen) {
            TitleScreen gui = (TitleScreen)event.getScreen();
            gui.f_96729_ = Main.SKYBOX;
        }
    }

    @SubscribeEvent
    public static void guiEvent(ScreenEvent.Init event) {
        if (event.getScreen() instanceof TitleScreen || event.getScreen() instanceof PauseScreen) {
            Screen gui = event.getScreen();
            Button b = Button.m_253074_((Component)Component.m_237113_((String)"Panorama"), p_86647_ -> Minecraft.m_91087_().m_91152_((Screen)new GuiPanoramaSelector())).m_252987_(4, 4, 60, 20).m_253136_();
            gui.f_96540_.add(b);
            gui.f_169369_.add(b);
        }
    }

    static {
        images = new HashMap<String, NativeImage[]>();
        currentName = "";
        takePanorama = false;
        index = 0;
        backupFov = 70.0;
        timer = 0;
    }

    public static enum Facing {
        SOUTH(0.0f, 0.0f),
        WEST(90.0f, 0.0f),
        NORTH(180.0f, 0.0f),
        EAST(-90.0f, 0.0f),
        UP(0.0f, -90.0f),
        DOWN(0.0f, 90.0f);

        float yaw;
        float pitch;

        private Facing(float yaw, float pitch) {
            this.yaw = yaw;
            this.pitch = pitch;
        }

        public static Facing getIndex(int index) {
            return Facing.values()[index];
        }
    }
}

