/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.panorama.main.registry;

import com.swdteam.panorama.main.Config;
import com.swdteam.panorama.main.Util;
import com.swdteam.panorama.main.registry.Panorama;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.DynamicTexture;

public class PanoramaRegistry {
    public static List<Panorama> PANORAMAS = new ArrayList<Panorama>();

    public static void setup() {
        PANORAMAS.clear();
        File file = new File(Config.INSTANCE.save_directory);
        if (!file.exists()) {
            file.mkdirs();
        }
        for (File f : file.listFiles()) {
            if (!f.getName().endsWith(".zip")) continue;
            try {
                Util.loadPackIcon(f.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void addPanorama(String s, DynamicTexture icon) {
        Panorama p = new Panorama(s);
        p.setIcon(icon);
        PANORAMAS.add(p);
    }

    public static List<Panorama> getAllForName(String s) {
        ArrayList<Panorama> l = new ArrayList<Panorama>();
        for (int i = 0; i < PANORAMAS.size(); ++i) {
            Panorama p = PANORAMAS.get(i);
            if (!p.getPanoramaName().toLowerCase().contains(s.toLowerCase())) continue;
            l.add(p);
        }
        return l;
    }
}

