/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.panorama.registry;

import com.swdteam.panorama.Config;
import com.swdteam.panorama.Util;
import com.swdteam.panorama.registry.PanoramaInstance;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1043;

@Environment(value=EnvType.CLIENT)
public class PanoramaRegistry {
    public static List<PanoramaInstance> PANORAMAS = new ArrayList<PanoramaInstance>();

    public static void setup() {
        PANORAMAS.clear();
        File file = new File(Config.INSTANCE.save_directory);
        if (!file.exists()) {
            file.mkdirs();
        }
        for (File f : file.listFiles()) {
            if (!f.getName().endsWith(".zip")) continue;
            try {
                Util.loadPackIcon(f.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void addPanorama(String s, class_1043 icon) {
        PanoramaInstance p = new PanoramaInstance(s);
        p.setIcon(icon);
        PANORAMAS.add(p);
    }

    public static List<PanoramaInstance> getAllForName(String s) {
        ArrayList<PanoramaInstance> l = new ArrayList<PanoramaInstance>();
        for (int i = 0; i < PANORAMAS.size(); ++i) {
            PanoramaInstance p = PANORAMAS.get(i);
            if (!p.getPanoramaName().toLowerCase().contains(s.toLowerCase())) continue;
            l.add(p);
        }
        return l;
    }
}

