/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiFunction;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.client.book.BookContentLoader;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public final class BookContentClasspathLoader
implements BookContentLoader {
    public static final BookContentClasspathLoader INSTANCE = new BookContentClasspathLoader();

    private BookContentClasspathLoader() {
    }

    private BiFunction<Path, Path, Boolean> pred(String modId, List<class_2960> list) {
        return (root, file) -> {
            Path rel = root.relativize((Path)file);
            String relName = rel.toString();
            if (relName.endsWith(".json")) {
                relName = FilenameUtils.removeExtension((String)FilenameUtils.separatorsToUnix((String)relName));
                class_2960 res = new class_2960(modId, relName);
                list.add(res);
            }
            return true;
        };
    }

    @Override
    public void findFiles(Book book, String dir, List<class_2960> list) {
        ModContainer mod = book.owner;
        String id = mod.getMetadata().getId();
        BookRegistry.findFiles(mod, String.format("data/%s/%s/%s/%s/%s", id, "patchouli_books", book.id.method_12832(), "en_us", dir), path -> true, this.pred(id, list), false);
    }

    @Override
    @Nullable
    public InputStream loadJson(Book book, class_2960 resloc, @Nullable class_2960 fallback) {
        String path = "data/" + resloc.method_12836() + "/" + resloc.method_12832();
        Patchouli.LOGGER.debug("Loading {}", (Object)path);
        try {
            return Files.newInputStream(book.owner.getPath(path), new OpenOption[0]);
        }
        catch (IOException ex) {
            if (fallback != null) {
                Patchouli.LOGGER.debug("Failed to load {}. Switching to fallback. ({})", (Object)resloc, (Object)ex.getMessage());
                return this.loadJson(book, fallback, null);
            }
            Patchouli.LOGGER.warn("Failed to load {}.", (Object)resloc, (Object)ex);
            return null;
        }
    }
}

