/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.client.book.BookContentLoader;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.Book;

public final class BookContentResourceLoader
implements BookContentLoader {
    public static final BookContentResourceLoader INSTANCE = new BookContentResourceLoader();

    private BookContentResourceLoader() {
    }

    @Override
    public void findFiles(Book book, String dir, List<class_2960> list) {
        String prefix = String.format("%s/%s/%s/%s", "patchouli_books", book.id.method_12832(), "en_us", dir);
        Collection files = class_310.method_1551().method_1478().method_14488(prefix, p -> p.endsWith(".json"));
        files.stream().distinct().filter(file -> file.method_12836().equals(book.id.method_12836())).map(file -> {
            Preconditions.checkArgument((boolean)file.method_12832().startsWith(prefix));
            Preconditions.checkArgument((boolean)file.method_12832().endsWith(".json"));
            String newPath = file.method_12832().substring(prefix.length(), file.method_12832().length() - ".json".length());
            if (newPath.startsWith("/")) {
                newPath = newPath.substring(1);
            }
            return new class_2960(file.method_12836(), newPath);
        }).forEach(list::add);
    }

    @Override
    @Nullable
    public InputStream loadJson(Book book, class_2960 file, @Nullable class_2960 fallback) {
        Patchouli.LOGGER.debug("Loading {}", (Object)file);
        class_3300 manager = class_310.method_1551().method_1478();
        try {
            if (manager.method_18234(file)) {
                return manager.method_14486(file).method_14482();
            }
            if (fallback != null && manager.method_18234(fallback)) {
                return manager.method_14486(fallback).method_14482();
            }
            return null;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

