/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import vazkii.patchouli.client.book.AbstractReadStateHolder;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.GuiBookLanding;
import vazkii.patchouli.client.book.template.BookTemplate;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.util.ItemStackUtil;

public class BookContents
extends AbstractReadStateHolder {
    public static final Map<class_2960, Supplier<BookTemplate>> addonTemplates = new ConcurrentHashMap<class_2960, Supplier<BookTemplate>>();
    private final Book book;
    public final Map<class_2960, BookCategory> categories;
    public final Map<class_2960, BookEntry> entries;
    private final Map<ItemStackUtil.StackWrapper, Pair<BookEntry, Integer>> recipeMappings;
    private final boolean errored;
    @Nullable
    private final Exception exception;
    public final Deque<GuiBook> guiStack = new ArrayDeque<GuiBook>();
    public GuiBook currentGui = null;

    private BookContents(Book book, @Nullable Exception e) {
        this.book = book;
        this.errored = e != null;
        this.exception = e;
        this.categories = Collections.emptyMap();
        this.entries = Collections.emptyMap();
        this.recipeMappings = Collections.emptyMap();
    }

    public static BookContents empty(Book book, @Nullable Exception e) {
        return new BookContents(book, e);
    }

    public BookContents(Book book, ImmutableMap<class_2960, BookCategory> categories, ImmutableMap<class_2960, BookEntry> entries, ImmutableMap<ItemStackUtil.StackWrapper, Pair<BookEntry, Integer>> recipeMappings) {
        this.book = book;
        this.categories = categories;
        this.entries = entries;
        this.recipeMappings = recipeMappings;
        this.errored = false;
        this.exception = null;
    }

    public boolean isErrored() {
        return this.errored;
    }

    @Nullable
    public Exception getException() {
        return this.exception;
    }

    public Pair<BookEntry, Integer> getEntryForStack(class_1799 stack) {
        return this.recipeMappings.get(ItemStackUtil.wrapStack(stack));
    }

    public GuiBook getCurrentGui() {
        if (this.currentGui == null) {
            this.currentGui = new GuiBookLanding(this.book);
        }
        return this.currentGui;
    }

    public void openLexiconGui(GuiBook gui, boolean push) {
        if (gui.canBeOpened()) {
            class_310 mc = class_310.method_1551();
            if (push && mc.field_1755 instanceof GuiBook && gui != mc.field_1755) {
                this.guiStack.push((GuiBook)mc.field_1755);
            }
            mc.method_1507((class_437)gui);
            gui.onFirstOpened();
        }
    }

    @Override
    protected EntryDisplayState computeReadState() {
        Stream<EntryDisplayState> stream = this.categories.values().stream().filter(BookCategory::isRootCategory).map(AbstractReadStateHolder::getReadState);
        return BookContents.mostImportantState(stream);
    }

    public final void checkValidCurrentEntry() {
        if (!this.getCurrentGui().canBeOpened()) {
            this.currentGui = null;
            this.guiStack.clear();
        }
    }

    public final void setTopEntry(class_2960 entryId, int page) {
        BookEntry entry = this.entries.get(entryId);
        if (!entry.isLocked()) {
            GuiBookEntry currEntry;
            GuiBook prevGui = this.getCurrentGui();
            int spread = page / 2;
            this.currentGui = new GuiBookEntry(this.book, entry, spread);
            GuiBook guiBook = prevGui;
            if (guiBook instanceof GuiBookEntry && (currEntry = (GuiBookEntry)guiBook).getEntry() == entry && currEntry.getSpread() == spread) {
                return;
            }
            entry.getBook().getContents().guiStack.push(prevGui);
        }
    }
}

