/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.base;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import vazkii.patchouli.client.base.BookModel;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.handler.BookRightClickHandler;
import vazkii.patchouli.client.handler.MultiblockVisualizationHandler;
import vazkii.patchouli.client.handler.TooltipHandler;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.ItemModBook;
import vazkii.patchouli.common.item.PatchouliItems;

public class ClientInitializer {
    public void onInitializeClient() {
        ClientBookRegistry.INSTANCE.init();
        PersistentData.setup();
        ClientTicker.init();
        BookRightClickHandler.init();
        MultiblockVisualizationHandler.init();
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.phase == TickEvent.Phase.START) {
                ClientTicker.renderTickStart(e.renderTickTime);
            } else {
                ClientTicker.renderTickEnd();
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> MultiblockVisualizationHandler.onWorldRenderLast(e.getMatrixStack()));
        MinecraftForge.EVENT_BUS.addListener(e -> ClientAdvancements.playerLogout());
        MinecraftForge.EVENT_BUS.addListener(e -> TooltipHandler.onTooltip(e.getMatrixStack(), e.getStack(), e.getX(), e.getY()));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(e -> ClientInitializer.replaceBookModel((ModelBakery)e.getModelLoader(), e.getModelRegistry()));
    }

    public static void replaceBookModel(ModelBakery loader, Map<ResourceLocation, BakedModel> bakedRegistry) {
        ModelResourceLocation key = new ModelResourceLocation(PatchouliItems.BOOK_ID, "inventory");
        BakedModel oldModel = bakedRegistry.get(key);
        if (oldModel != null) {
            bakedRegistry.put((ResourceLocation)key, new BookModel(oldModel, loader));
        }
    }

    @Mod.EventBusSubscriber(modid="patchouli", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class ClownyModLoaderDesign {
        private ClownyModLoaderDesign() {
        }

        @SubscribeEvent
        public static void modelRegistry(ModelRegistryEvent e) {
            BookRegistry.INSTANCE.books.values().stream().map(b -> new ModelResourceLocation(b.model, "inventory")).forEach(ModelLoader::addSpecialModel);
            ItemPropertyFunction prop = (stack, world, entity, seed) -> ItemModBook.getCompletion(stack);
            ItemProperties.register((Item)PatchouliItems.BOOK, (ResourceLocation)new ResourceLocation("patchouli", "completion"), (ItemPropertyFunction)prop);
        }

        @SubscribeEvent
        public static void registerReloadListeners(RegisterClientReloadListenersEvent e) {
            e.registerReloadListener((PreparableReloadListener)new ResourceManagerReloadListener(){

                public void m_6213_(ResourceManager manager) {
                    if (Minecraft.m_91087_().f_91073_ != null) {
                        Patchouli.LOGGER.info("Reloading resource pack-based books, world is nonnull");
                        ClientBookRegistry.INSTANCE.reload(true);
                    } else {
                        Patchouli.LOGGER.info("Not reloading resource pack-based books as client world is missing");
                    }
                }
            });
        }
    }
}

