/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import vazkii.patchouli.client.book.BookContentLoader;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.Book;

public final class BookContentResourceLoader
implements BookContentLoader {
    public static final BookContentResourceLoader INSTANCE = new BookContentResourceLoader();

    private BookContentResourceLoader() {
    }

    @Override
    public void findFiles(Book book, String dir, List<ResourceLocation> list) {
        String prefix = String.format("%s/%s/%s/%s", "patchouli_books", book.id.m_135815_(), "en_us", dir);
        Collection files = Minecraft.m_91087_().m_91098_().m_6540_(prefix, p -> p.endsWith(".json"));
        files.stream().distinct().filter(file -> file.m_135827_().equals(book.id.m_135827_())).map(file -> {
            Preconditions.checkArgument((boolean)file.m_135815_().startsWith(prefix));
            Preconditions.checkArgument((boolean)file.m_135815_().endsWith(".json"));
            String newPath = file.m_135815_().substring(prefix.length(), file.m_135815_().length() - ".json".length());
            if (newPath.startsWith("/")) {
                newPath = newPath.substring(1);
            }
            return new ResourceLocation(file.m_135827_(), newPath);
        }).forEach(list::add);
    }

    @Override
    @Nullable
    public InputStream loadJson(Book book, ResourceLocation file, @Nullable ResourceLocation fallback) {
        Patchouli.LOGGER.debug("Loading {}", (Object)file);
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        try {
            if (manager.m_7165_(file)) {
                return manager.m_142591_(file).m_6679_();
            }
            if (fallback != null && manager.m_7165_(fallback)) {
                return manager.m_142591_(fallback).m_6679_();
            }
            return null;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

