/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookIcon;
import vazkii.patchouli.client.book.gui.GuiBook;

public class GuiButtonCategory
extends Button {
    private static final int ANIM_TIME = 5;
    final GuiBook parent;
    BookCategory category;
    final BookIcon icon;
    final Component name;
    final int u;
    final int v;
    float timeHovered;

    public GuiButtonCategory(GuiBook parent, int x, int y, BookCategory category, Button.OnPress onPress) {
        this(parent, x, y, category.getIcon(), category.getName(), onPress);
        this.category = category;
    }

    public GuiButtonCategory(GuiBook parent, int x, int y, BookIcon icon, Component name, Button.OnPress onPress) {
        super(parent.bookLeft + x, parent.bookTop + y, 20, 20, name, onPress);
        this.parent = parent;
        this.u = x;
        this.v = y;
        this.icon = icon;
        this.name = name;
    }

    public void m_6303_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93623_) {
            boolean locked;
            this.timeHovered = this.m_5702_() ? Math.min(5.0f, this.timeHovered + ClientTicker.delta) : Math.max(0.0f, this.timeHovered - ClientTicker.delta);
            float time = Math.max(0.0f, Math.min(5.0f, this.timeHovered + (this.m_5702_() ? partialTicks : -partialTicks)));
            float transparency = 0.5f - time / 5.0f * 0.5f;
            boolean bl = locked = this.category != null && this.category.isLocked();
            if (locked) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                GuiBook.drawLock(ms, this.parent.book, this.f_93620_ + 2, this.f_93621_ + 2);
            } else {
                this.icon.render(ms, this.f_93620_ + 2, this.f_93621_ + 2);
            }
            ms.m_85836_();
            RenderSystem.m_69478_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
            ms.m_85837_(0.0, 0.0, 200.0);
            GuiBook.drawFromTexture(ms, this.parent.book, this.f_93620_, this.f_93621_, this.u, this.v, this.f_93618_, this.f_93619_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.category != null && !this.category.isLocked()) {
                GuiBook.drawMarking(ms, this.parent.book, this.f_93620_, this.f_93621_, 0, this.category.getReadState());
            }
            ms.m_85849_();
            if (this.m_5702_()) {
                this.parent.setTooltip(new Component[]{locked ? new TranslatableComponent("patchouli.gui.lexicon.locked").m_130940_(ChatFormatting.GRAY) : this.name});
            }
        }
    }

    public void m_7435_(SoundManager soundHandlerIn) {
        if (this.category != null && !this.category.isLocked()) {
            GuiBook.playBookFlipSound(this.parent.book);
        }
    }

    public BookCategory getCategory() {
        return this.category;
    }
}

