/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.util.EntityUtil;

public class PageEntity
extends PageWithText {
    @SerializedName(value="entity")
    public String entityId;
    float scale = 1.0f;
    @SerializedName(value="offset")
    float extraOffset = 0.0f;
    String name;
    boolean rotate = true;
    @SerializedName(value="default_rotation")
    float defaultRotation = -45.0f;
    transient boolean errored;
    transient Entity entity;
    transient Function<Level, Entity> creator;
    transient float renderScale;
    transient float offset;

    @Override
    public void build(BookEntry entry, BookContentsBuilder builder, int pageNum) {
        super.build(entry, builder, pageNum);
        this.creator = EntityUtil.loadEntity(this.entityId);
    }

    @Override
    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        this.loadEntity((Level)parent.getMinecraft().f_91073_);
    }

    @Override
    public int getTextHeight() {
        return 115;
    }

    @Override
    public void render(PoseStack ms, int mouseX, int mouseY, float pticks) {
        int x = 5;
        int y = 7;
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiBook.drawFromTexture(ms, this.book, x, y, 405, 149, 106, 106);
        if (this.name == null || this.name.isEmpty()) {
            if (this.entity != null) {
                this.parent.drawCenteredStringNoShadow(ms, this.entity.m_7755_().m_7532_(), 58, 0, this.book.headerColor);
            }
        } else {
            this.parent.drawCenteredStringNoShadow(ms, this.name, 58, 0, this.book.headerColor);
        }
        if (this.errored) {
            this.fontRenderer.m_92750_(ms, I18n.m_118938_((String)"patchouli.gui.lexicon.loading_error", (Object[])new Object[0]), 58.0f, 60.0f, 0xFF0000);
        }
        if (this.entity != null) {
            float rotation = this.rotate ? ClientTicker.total : this.defaultRotation;
            PageEntity.renderEntity(ms, this.entity, (Level)this.parent.getMinecraft().f_91073_, 58.0f, 60.0f, rotation, this.renderScale, this.offset);
        }
        super.render(ms, mouseX, mouseY, pticks);
    }

    public static void renderEntity(PoseStack ms, Entity entity, Level world, float x, float y, float rotation, float renderScale, float offset) {
        entity.f_19853_ = world;
        ms.m_85836_();
        ms.m_85837_((double)x, (double)y, 50.0);
        ms.m_85841_(renderScale, renderScale, renderScale);
        ms.m_85837_(0.0, (double)offset, 0.0);
        ms.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        ms.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        EntityRenderDispatcher erd = Minecraft.m_91087_().m_91290_();
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        erd.m_114468_(false);
        erd.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, ms, (MultiBufferSource)immediate, 0xF000F0);
        erd.m_114468_(true);
        immediate.m_109911_();
        ms.m_85849_();
    }

    private void loadEntity(Level world) {
        if (!(this.errored || this.entity != null && this.entity.m_6084_())) {
            try {
                this.entity = this.creator.apply(world);
                float width = this.entity.m_20205_();
                float height = this.entity.m_20206_();
                float entitySize = Math.max(1.0f, Math.max(width, height));
                this.renderScale = 100.0f / entitySize * 0.8f * this.scale;
                this.offset = Math.max(height, entitySize) * 0.5f + this.extraOffset;
            }
            catch (Exception e) {
                this.errored = true;
                Patchouli.LOGGER.error("Failed to load entity", (Throwable)e);
            }
        }
    }
}

