/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.template.component;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.PageEntity;
import vazkii.patchouli.client.book.template.TemplateComponent;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.util.EntityUtil;

public class ComponentEntity
extends TemplateComponent {
    @SerializedName(value="entity")
    public IVariable entityId;
    @SerializedName(value="render_size")
    float renderSize = 100.0f;
    boolean rotate = true;
    @SerializedName(value="default_rotation")
    float defaultRotation = -45.0f;
    transient boolean errored;
    transient Entity entity;
    transient Function<Level, Entity> creator;
    transient float renderScale;
    transient float offset;

    @Override
    public void build(BookContentsBuilder builder, BookPage page, BookEntry entry, int pageNum) {
        this.creator = EntityUtil.loadEntity(this.entityId.asString());
    }

    @Override
    public void onDisplayed(BookPage page, GuiBookEntry parent, int left, int top) {
        this.loadEntity((Level)page.mc.f_91073_);
    }

    @Override
    public void render(PoseStack ms, BookPage page, int mouseX, int mouseY, float pticks) {
        if (this.errored) {
            page.fontRenderer.m_92750_(ms, I18n.m_118938_((String)"patchouli.gui.lexicon.loading_error", (Object[])new Object[0]), (float)this.x, (float)this.y, 0xFF0000);
        }
        if (this.entity != null) {
            float rotation = this.rotate ? ClientTicker.total : this.defaultRotation;
            PageEntity.renderEntity(ms, this.entity, (Level)page.mc.f_91073_, this.x, this.y, rotation, this.renderScale, this.offset);
        }
    }

    @Override
    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        super.onVariablesAvailable(lookup);
        this.entityId = (IVariable)lookup.apply(this.entityId);
    }

    private void loadEntity(Level world) {
        if (!(this.errored || this.entity != null && this.entity.m_6084_())) {
            try {
                this.entity = this.creator.apply(world);
                float width = this.entity.m_20205_();
                float height = this.entity.m_20206_();
                float entitySize = Math.max(width, height);
                entitySize = Math.max(1.0f, entitySize);
                this.renderScale = this.renderSize / entitySize * 0.8f;
                this.offset = Math.max(height, entitySize) * 0.5f;
            }
            catch (Exception e) {
                this.errored = true;
                Patchouli.LOGGER.error("Failed to load entity", (Throwable)e);
            }
        }
    }
}

