/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.base;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.world.InteractionResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vazkii.patchouli.client.base.ClientInitializer;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.command.OpenBookCommand;
import vazkii.patchouli.common.handler.LecternEventHandler;
import vazkii.patchouli.common.handler.ReloadContentsHandler;
import vazkii.patchouli.common.item.PatchouliItems;
import vazkii.patchouli.common.network.NetworkHandler;

@Mod(value="patchouli")
public class Patchouli {
    public static final boolean debug = !FMLEnvironment.production;
    public static final String MOD_ID = "patchouli";
    public static final String PREFIX = "patchouli:";
    public static final Logger LOGGER = LogManager.getLogger((String)"patchouli");

    public Patchouli() {
        PatchouliSounds.init();
        PatchouliItems.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(e -> this.onInitialize());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(e -> new ClientInitializer().onInitializeClient()));
    }

    public void onInitialize() {
        PatchouliConfig.setup();
        MinecraftForge.EVENT_BUS.addListener(e -> this.registerCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher(), e.getEnvironment() == Commands.CommandSelection.DEDICATED));
        MinecraftForge.EVENT_BUS.addListener(e -> {
            InteractionResult result = LecternEventHandler.rightClick(e.getPlayer(), e.getWorld(), e.getHand(), e.getHitVec());
            if (result.m_19077_()) {
                e.setCanceled(true);
                e.setCancellationResult(result);
            }
        });
        NetworkHandler.registerMessages();
        BookRegistry.INSTANCE.init();
        ReloadContentsHandler.init();
    }

    private void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, boolean dedicated) {
        OpenBookCommand.register(dispatcher);
    }
}

