/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.base;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.forgespi.language.IModInfo;
import vazkii.patchouli.common.base.Patchouli;

public class PatchouliConfig {
    public static final ForgeConfigSpec.ConfigValue<Boolean> disableAdvancementLocking;
    public static final ForgeConfigSpec.ConfigValue<List<String>> noAdvancementBooks;
    public static final ForgeConfigSpec.ConfigValue<Boolean> testingMode;
    public static final ForgeConfigSpec.ConfigValue<String> inventoryButtonBook;
    public static final ForgeConfigSpec.ConfigValue<Boolean> useShiftForQuickLookup;
    public static final ForgeConfigSpec.EnumValue<TextOverflowMode> overflowMode;
    private static final Map<String, Boolean> CONFIG_FLAGS;
    private static final ForgeConfigSpec SPEC;

    public static void setup() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SPEC);
    }

    public static void reloadBuiltinFlags() {
        List mods = ModList.get().getMods();
        for (IModInfo info : mods) {
            PatchouliConfig.setFlag("mod:" + info.getModId(), true);
        }
        PatchouliConfig.setFlag("debug", Patchouli.debug);
        PatchouliConfig.setFlag("advancements_disabled", (Boolean)disableAdvancementLocking.get());
        PatchouliConfig.setFlag("testing_mode", (Boolean)testingMode.get());
        for (String book : (List)noAdvancementBooks.get()) {
            PatchouliConfig.setFlag("advancements_disabled_" + book, true);
        }
    }

    public static boolean getConfigFlag(String name) {
        Boolean b;
        if (name.startsWith("&")) {
            return PatchouliConfig.getConfigFlagAND(name.replaceAll("[&|]", "").split(","));
        }
        if (name.startsWith("|")) {
            return PatchouliConfig.getConfigFlagOR(name.replaceAll("[&|]", "").split(","));
        }
        boolean target = true;
        if (name.startsWith("!")) {
            name = name.substring(1);
            target = false;
        }
        if ((b = CONFIG_FLAGS.get(name = name.trim().toLowerCase(Locale.ROOT))) == null) {
            if (!name.startsWith("mod:")) {
                Patchouli.LOGGER.warn("Queried for unknown config flag: {}", (Object)name);
            }
            b = false;
        }
        return b == target;
    }

    public static boolean getConfigFlagAND(String[] tokens) {
        for (String s : tokens) {
            if (PatchouliConfig.getConfigFlag(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean getConfigFlagOR(String[] tokens) {
        for (String s : tokens) {
            if (!PatchouliConfig.getConfigFlag(s)) continue;
            return true;
        }
        return false;
    }

    public static void setFlag(String flag, boolean value) {
        CONFIG_FLAGS.put(flag.trim().toLowerCase(Locale.ROOT), value);
    }

    static {
        CONFIG_FLAGS = new ConcurrentHashMap<String, Boolean>();
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        disableAdvancementLocking = builder.comment("Set this to true to disable advancement locking for ALL books, making all entries visible at all times. Config Flag: advancements_disabled").define("disableAdvancementLocking", false);
        noAdvancementBooks = builder.comment("Granular list of Book ID's to disable advancement locking for, e.g. [ \"botania:lexicon\" ]. Config Flags: advancements_disabled_<bookid>").define("noAdvancementBooks", Collections.emptyList());
        testingMode = builder.comment("Enable testing mode. By default this doesn't do anything, but you can use the config flag in your books if you want. Config Flag: testing_mode").define("testingMode", false);
        inventoryButtonBook = builder.comment("Set this to the ID of a book to have it show up in players' inventories, replacing the recipe book.").define("inventoryButtonBook", (Object)"");
        useShiftForQuickLookup = builder.comment("Set this to true to use Shift instead of Ctrl for the inventory quick lookup feature.").define("useShiftForQuickLookup", false);
        overflowMode = builder.comment("Set how text overflow should be coped with: overflow the text off the page, truncate overflowed text, or resize everything to fit. Relogin after changing.").defineEnum("textOverflowMode", (Enum)TextOverflowMode.OVERFLOW);
        SPEC = builder.build();
    }

    public static enum TextOverflowMode {
        OVERFLOW,
        TRUNCATE,
        RESIZE;

    }
}

