/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.base.Patchouli;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.PatchouliItems;

public abstract class BookRecipe<T extends CraftingRecipe>
implements CraftingRecipe {
    protected final T compose;
    private final ResourceLocation outputBook;

    protected BookRecipe(T compose, ResourceLocation outputBook) {
        this.compose = compose;
        this.outputBook = outputBook;
    }

    public boolean matches(CraftingContainer inventory, Level world) {
        return this.compose.m_5818_((Container)inventory, world);
    }

    public ItemStack assemble(CraftingContainer inventory) {
        return this.m_8043_();
    }

    public boolean m_8004_(int width, int height) {
        return this.compose.m_8004_(width, height);
    }

    public ItemStack m_8043_() {
        return PatchouliAPI.get().getBookStack(this.outputBook);
    }

    public ResourceLocation m_6423_() {
        return this.compose.m_6423_();
    }

    public abstract RecipeSerializer<?> m_7707_();

    protected static abstract class WrapperSerializer<R extends CraftingRecipe, T extends BookRecipe<R>>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        protected WrapperSerializer() {
        }

        protected abstract RecipeSerializer<R> getSerializer();

        protected abstract T getRecipe(R var1, ResourceLocation var2);

        public T fromJson(ResourceLocation id, JsonObject json) {
            if (!json.has("result")) {
                JsonObject object = new JsonObject();
                object.addProperty("item", PatchouliItems.BOOK_ID.toString());
                json.add("result", (JsonElement)object);
            }
            CraftingRecipe recipe = (CraftingRecipe)this.getSerializer().m_6729_(id, json);
            ResourceLocation outputBook = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"book"));
            if (!BookRegistry.INSTANCE.books.containsKey(outputBook)) {
                Patchouli.LOGGER.warn("Book {} in recipe {} does not exist!", (Object)outputBook, (Object)id);
            }
            return this.getRecipe(recipe, outputBook);
        }

        public T fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            CraftingRecipe recipe = (CraftingRecipe)this.getSerializer().m_8005_(id, buf);
            ResourceLocation outputBook = buf.m_130281_();
            return this.getRecipe(recipe, outputBook);
        }

        public void toNetwork(FriendlyByteBuf buf, T recipe) {
            this.getSerializer().m_6178_(buf, ((BookRecipe)recipe).compose);
            buf.m_130085_(((BookRecipe)recipe).m_6423_());
        }
    }
}

