/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookEye;
import vazkii.patchouli.client.book.page.abstr.PageWithText;
import vazkii.patchouli.client.handler.MultiblockVisualizationHandler;
import vazkii.patchouli.common.multiblock.AbstractMultiblock;
import vazkii.patchouli.common.multiblock.MultiblockRegistry;
import vazkii.patchouli.common.multiblock.SerializedMultiblock;

public class PageMultiblock
extends PageWithText {
    private static final Random RAND = new Random();
    String name = "";
    @SerializedName(value="multiblock_id")
    ResourceLocation multiblockId;
    @SerializedName(value="multiblock")
    SerializedMultiblock serializedMultiblock;
    @SerializedName(value="enable_visualize")
    boolean showVisualizeButton = true;
    private transient AbstractMultiblock multiblockObj;
    private transient Button visualizeButton;
    private final transient Set<BlockEntity> erroredTiles = Collections.newSetFromMap(new WeakHashMap());

    @Override
    public void build(BookEntry entry, BookContentsBuilder builder, int pageNum) {
        IMultiblock mb;
        super.build(entry, builder, pageNum);
        if (this.multiblockId != null && (mb = MultiblockRegistry.MULTIBLOCKS.get(this.multiblockId)) instanceof AbstractMultiblock) {
            this.multiblockObj = (AbstractMultiblock)mb;
        }
        if (this.multiblockObj == null && this.serializedMultiblock != null) {
            this.multiblockObj = this.serializedMultiblock.toMultiblock();
        }
        if (this.multiblockObj == null) {
            throw new IllegalArgumentException("No multiblock located for " + this.multiblockId);
        }
    }

    @Override
    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        if (this.showVisualizeButton) {
            this.visualizeButton = new GuiButtonBookEye(parent, 12, 97, this::handleButtonVisualize);
            this.addButton(this.visualizeButton);
        }
    }

    @Override
    public int getTextHeight() {
        return 115;
    }

    @Override
    public void render(PoseStack ms, int mouseX, int mouseY, float pticks) {
        int x = 5;
        int y = 7;
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiBook.drawFromTexture(ms, this.book, x, y, 405, 149, 106, 106);
        this.parent.drawCenteredStringNoShadow(ms, this.i18n(this.name), 58, 0, this.book.headerColor);
        if (this.multiblockObj != null) {
            this.renderMultiblock(ms);
        }
        super.render(ms, mouseX, mouseY, pticks);
    }

    public void handleButtonVisualize(Button button) {
        String entryKey = this.parent.getEntry().getId().toString();
        PersistentData.DataHolder.BookData.Bookmark bookmark = new PersistentData.DataHolder.BookData.Bookmark(entryKey, this.pageNum / 2);
        MultiblockVisualizationHandler.setMultiblock(this.multiblockObj, this.i18nText(this.name), bookmark, true);
        this.parent.addBookmarkButtons();
        if (!PersistentData.data.clickedVisualize) {
            PersistentData.data.clickedVisualize = true;
            PersistentData.save();
        }
    }

    private void renderMultiblock(PoseStack ms) {
        this.multiblockObj.setWorld((Level)this.mc.f_91073_);
        Vec3i size = this.multiblockObj.getSize();
        int sizeX = size.m_123341_();
        int sizeY = size.m_123342_();
        int sizeZ = size.m_123343_();
        float maxX = 90.0f;
        float maxY = 90.0f;
        float diag = (float)Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
        float scaleX = maxX / diag;
        float scaleY = maxY / (float)sizeY;
        float scale = -Math.min(scaleX, scaleY);
        int xPos = 58;
        int yPos = 60;
        ms.m_85836_();
        ms.m_85837_((double)xPos, (double)yPos, 100.0);
        ms.m_85841_(scale, scale, scale);
        ms.m_85837_((double)(-((float)sizeX) / 2.0f), (double)(-((float)sizeY) / 2.0f), 0.0);
        Vector4f eye = new Vector4f(0.0f, 0.0f, -100.0f, 1.0f);
        Matrix4f rotMat = new Matrix4f();
        rotMat.m_27624_();
        ms.m_85845_(Vector3f.f_122223_.m_122240_(-30.0f));
        rotMat.m_27646_(Vector3f.f_122223_.m_122240_(30.0f));
        float offX = (float)(-sizeX) / 2.0f;
        float offZ = (float)(-sizeZ) / 2.0f + 1.0f;
        float time = (float)this.parent.ticksInBook * 0.5f;
        if (!Screen.m_96638_()) {
            time += ClientTicker.partialTicks;
        }
        ms.m_85837_((double)(-offX), 0.0, (double)(-offZ));
        ms.m_85845_(Vector3f.f_122225_.m_122240_(time));
        rotMat.m_27646_(Vector3f.f_122225_.m_122240_(-time));
        ms.m_85845_(Vector3f.f_122225_.m_122240_(45.0f));
        rotMat.m_27646_(Vector3f.f_122225_.m_122240_(-45.0f));
        ms.m_85837_((double)offX, 0.0, (double)offZ);
        eye.m_123607_(rotMat);
        eye.m_123621_();
        this.renderElements(ms, this.multiblockObj, BlockPos.m_121940_((BlockPos)BlockPos.f_121853_, (BlockPos)new BlockPos(sizeX - 1, sizeY - 1, sizeZ - 1)), eye);
        ms.m_85849_();
    }

    private void renderElements(PoseStack ms, AbstractMultiblock mb, Iterable<? extends BlockPos> blocks, Vector4f eye) {
        ms.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ms.m_85837_(0.0, 0.0, -1.0);
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        this.doWorldRenderPass(ms, mb, blocks, buffers, eye);
        this.doTileEntityRenderPass(ms, mb, blocks, (MultiBufferSource)buffers, eye);
        buffers.m_109911_();
        ms.m_85849_();
    }

    private void doWorldRenderPass(PoseStack ms, AbstractMultiblock mb, Iterable<? extends BlockPos> blocks, @Nonnull MultiBufferSource.BufferSource buffers, Vector4f eye) {
        for (BlockPos blockPos : blocks) {
            BlockState bs = mb.m_8055_(blockPos);
            VertexConsumer buffer = buffers.m_6299_(ItemBlockRenderTypes.m_109282_((BlockState)bs));
            ms.m_85836_();
            ms.m_85837_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
            Minecraft.m_91087_().m_91289_().m_110924_(bs, blockPos, (BlockAndTintGetter)mb, ms, buffer, false, RAND);
            ms.m_85849_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTileEntityRenderPass(PoseStack ms, AbstractMultiblock mb, Iterable<? extends BlockPos> blocks, MultiBufferSource buffers, Vector4f eye) {
        for (BlockPos blockPos : blocks) {
            BlockEntity te = mb.m_7702_(blockPos);
            if (te == null || this.erroredTiles.contains(te)) continue;
            te.m_142339_((Level)this.mc.f_91073_);
            te.m_155250_(mb.m_8055_(blockPos));
            ms.m_85836_();
            ms.m_85837_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
            try {
                BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(te);
                if (renderer == null) continue;
                renderer.m_6922_(te, ClientTicker.partialTicks, ms, buffers, 0xF000F0, OverlayTexture.f_118083_);
            }
            catch (Exception e) {
                this.erroredTiles.add(te);
                PatchouliAPI.LOGGER.error("An exception occured rendering tile entity", (Throwable)e);
            }
            finally {
                ms.m_85849_();
            }
        }
    }
}

