/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.book;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import org.apache.commons.lang3.tuple.Triple;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.book.BookContents;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookIcon;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.item.ItemModBook;
import vazkii.patchouli.common.util.ItemStackUtil;
import vazkii.patchouli.common.util.SerializationUtil;
import vazkii.patchouli.xplat.XplatModContainer;

public class Book {
    private static final String[] ORDINAL_SUFFIXES = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
    private static final class_2960 DEFAULT_MODEL = new class_2960("patchouli", "book_brown");
    private static final class_2960 DEFAULT_BOOK_TEXTURE = new class_2960("patchouli", "textures/gui/book_brown.png");
    private static final class_2960 DEFAULT_FILLER_TEXTURE = new class_2960("patchouli", "textures/gui/page_filler.png");
    private static final class_2960 DEFAULT_CRAFTING_TEXTURE = new class_2960("patchouli", "textures/gui/crafting.png");
    private static final class_2960 UNICODE_FONT_ID = new class_2960("patchouli", "unicode_font");
    private static final Map<String, String> DEFAULT_MACROS = (Map)class_156.method_656(() -> {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("$(list", "$(li");
        ret.put("/$", "$()");
        ret.put("<br>", "$(br)");
        ret.put("$(item)", "$(#b0b)");
        ret.put("$(thing)", "$(#490)");
        return ret;
    });
    private BookContents contents;
    private boolean wasUpdated = false;
    public final XplatModContainer owner;
    public final class_2960 id;
    private Supplier<class_1799> bookItem;
    public final int textColor;
    public final int headerColor;
    public final int nameplateColor;
    public final int linkColor;
    public final int linkHoverColor;
    public final int progressBarColor;
    public final int progressBarBackground;
    public final boolean isExtension;
    public final List<Book> extensions = new LinkedList<Book>();
    @Nullable
    public Book extensionTarget;
    public final boolean isExternal;
    public final String name;
    public final String landingText;
    public final class_2960 bookTexture;
    public final class_2960 fillerTexture;
    public final class_2960 craftingTexture;
    public final class_2960 model;
    public final boolean useBlockyFont;
    public final class_2960 openSound;
    public final class_2960 flipSound;
    public final boolean showProgress;
    public final String indexIconRaw;
    public final String version;
    public final String subtitle;
    public final String creativeTab;
    @Nullable
    public final class_2960 advancementsTab;
    public final boolean noBook;
    public final boolean showToasts;
    @Nullable
    public final class_2960 extensionTargetID;
    public final boolean allowExtensions;
    public final boolean pauseGame;
    public final boolean useResourcePack;
    public final boolean isPamphlet;
    public final boolean i18n;
    @Nullable
    public final PatchouliConfig.TextOverflowMode overflowMode;
    public final Map<String, String> macros = new HashMap<String, String>();

    private static int parseColor(JsonObject root, String key, String defaultColor, boolean isExtension) {
        if (isExtension) {
            return 0;
        }
        return 0xFF000000 | Integer.parseInt(class_3518.method_15253((JsonObject)root, (String)key, (String)defaultColor), 16);
    }

    public Book(JsonObject root, XplatModContainer owner, class_2960 id, boolean external) {
        this.name = class_3518.method_15265((JsonObject)root, (String)"name");
        this.landingText = class_3518.method_15253((JsonObject)root, (String)"landing_text", (String)"patchouli.gui.lexicon.landing_info");
        this.bookTexture = SerializationUtil.getAsResourceLocation(root, "book_texture", DEFAULT_BOOK_TEXTURE);
        this.fillerTexture = SerializationUtil.getAsResourceLocation(root, "filler_texture", DEFAULT_FILLER_TEXTURE);
        this.craftingTexture = SerializationUtil.getAsResourceLocation(root, "crafting_texture", DEFAULT_CRAFTING_TEXTURE);
        this.model = SerializationUtil.getAsResourceLocation(root, "model", DEFAULT_MODEL);
        this.useBlockyFont = class_3518.method_15258((JsonObject)root, (String)"use_blocky_font", (boolean)false);
        this.owner = owner;
        this.id = id;
        this.isExternal = external;
        this.extensionTargetID = SerializationUtil.getAsResourceLocation(root, "extend", null);
        this.isExtension = this.extensionTargetID != null;
        this.textColor = Book.parseColor(root, "text_color", "000000", this.isExtension);
        this.headerColor = Book.parseColor(root, "header_color", "333333", this.isExtension);
        this.nameplateColor = Book.parseColor(root, "nameplate_color", "FFDD00", this.isExtension);
        this.linkColor = Book.parseColor(root, "link_color", "0000EE", this.isExtension);
        this.linkHoverColor = Book.parseColor(root, "link_hover_color", "8800EE", this.isExtension);
        this.progressBarColor = Book.parseColor(root, "progress_bar_color", "FFFF55", this.isExtension);
        this.progressBarBackground = Book.parseColor(root, "progress_bar_background", "DDDDDD", this.isExtension);
        this.openSound = SerializationUtil.getAsResourceLocation(root, "open_sound", PatchouliSounds.BOOK_OPEN.method_14833());
        this.flipSound = SerializationUtil.getAsResourceLocation(root, "flip_sound", PatchouliSounds.BOOK_FLIP.method_14833());
        this.showProgress = class_3518.method_15258((JsonObject)root, (String)"show_progress", (boolean)true);
        this.indexIconRaw = class_3518.method_15253((JsonObject)root, (String)"index_icon", (String)"");
        this.version = class_3518.method_15253((JsonObject)root, (String)"version", (String)"0");
        this.subtitle = class_3518.method_15253((JsonObject)root, (String)"subtitle", (String)"");
        this.creativeTab = class_3518.method_15253((JsonObject)root, (String)"creative_tab", (String)"misc");
        this.advancementsTab = SerializationUtil.getAsResourceLocation(root, "advancements_tab", null);
        this.noBook = class_3518.method_15258((JsonObject)root, (String)"dont_generate_book", (boolean)false);
        this.showToasts = class_3518.method_15258((JsonObject)root, (String)"show_toasts", (boolean)true);
        this.allowExtensions = class_3518.method_15258((JsonObject)root, (String)"allow_extensions", (boolean)true);
        this.pauseGame = class_3518.method_15258((JsonObject)root, (String)"pause_game", (boolean)false);
        this.useResourcePack = class_3518.method_15258((JsonObject)root, (String)"use_resource_pack", (boolean)false);
        this.isPamphlet = class_3518.method_15258((JsonObject)root, (String)"pamphlet", (boolean)false);
        this.i18n = class_3518.method_15258((JsonObject)root, (String)"i18n", (boolean)false);
        this.overflowMode = SerializationUtil.getAsEnum(root, "text_overflow_mode", PatchouliConfig.TextOverflowMode.class, null);
        String customBookItem = class_3518.method_15253((JsonObject)root, (String)"custom_book_item", (String)"");
        if (this.noBook) {
            Triple<class_2960, Integer, class_2487> parsed = ItemStackUtil.parseItemStackString(customBookItem);
            this.bookItem = Suppliers.memoize(() -> ItemStackUtil.loadFromParsed(parsed));
        } else {
            this.bookItem = Suppliers.memoize(() -> ItemModBook.forBook(id));
        }
        if (!this.isExtension) {
            this.macros.putAll(DEFAULT_MACROS);
            for (Map.Entry e : class_3518.method_15281((JsonObject)root, (String)"macros", (JsonObject)new JsonObject()).entrySet()) {
                this.macros.put((String)e.getKey(), class_3518.method_15287((JsonElement)((JsonElement)e.getValue()), (String)"macro value"));
            }
        }
    }

    public String getModNamespace() {
        return this.id.method_12836();
    }

    public class_1799 getBookItem() {
        return this.bookItem.get();
    }

    public void markUpdated() {
        this.wasUpdated = true;
    }

    public boolean popUpdated() {
        boolean updated = this.wasUpdated;
        this.wasUpdated = false;
        return updated;
    }

    @Deprecated
    public void reloadContents() {
        this.reloadContents(false);
    }

    public void reloadContents(boolean singleBook) {
        if (!this.isExtension) {
            BookContentsBuilder builder = new BookContentsBuilder(singleBook);
            try {
                builder.loadFrom(this);
            }
            catch (Exception e) {
                PatchouliAPI.LOGGER.error("Error loading book {}, using empty contents and ignoring extensions", (Object)this.id, (Object)e);
                this.contents = BookContents.empty(this, e);
            }
            for (Book extension : this.extensions) {
                try {
                    builder.loadFrom(extension);
                }
                catch (Exception e) {
                    PatchouliAPI.LOGGER.error("Error loading extending book {} with addon book {}, skipping", (Object)this.id, (Object)extension.id, (Object)e);
                }
            }
            try {
                this.contents = builder.build(this);
            }
            catch (Exception e) {
                PatchouliAPI.LOGGER.error("Error compiling book {}, using empty contents", (Object)this.id, (Object)e);
                this.contents = BookContents.empty(this, e);
            }
        }
    }

    public final boolean advancementsEnabled() {
        return PatchouliConfig.get().disableAdvancementLocking().get() == false && !PatchouliConfig.get().noAdvancementBooks().get().contains(this.id.toString());
    }

    public void reloadLocks(boolean suppressToasts) {
        this.getContents().entries.values().forEach(BookEntry::updateLockStatus);
        this.getContents().categories.values().forEach(c -> c.updateLockStatus(true));
        boolean updated = this.popUpdated();
        if (updated && !suppressToasts && this.advancementsEnabled() && this.showToasts) {
            ClientAdvancements.sendBookToast(this);
        }
    }

    public String getOwnerName() {
        return this.owner.getName();
    }

    public class_2583 getFontStyle() {
        if (this.useBlockyFont) {
            return class_2583.field_24360;
        }
        return class_2583.field_24360.method_27704(UNICODE_FONT_ID);
    }

    public class_5250 getSubtitle() {
        class_2588 editionStr;
        try {
            int ver = Integer.parseInt(this.version);
            if (ver == 0) {
                return new class_2588(this.subtitle);
            }
            editionStr = new class_2585(Book.numberToOrdinal(ver));
        }
        catch (NumberFormatException e) {
            editionStr = new class_2588("patchouli.gui.lexicon.dev_edition");
        }
        return new class_2588("patchouli.gui.lexicon.edition_str", new Object[]{editionStr});
    }

    public BookIcon getIcon() {
        if (this.indexIconRaw == null || this.indexIconRaw.isEmpty()) {
            return new BookIcon.StackIcon(this.getBookItem());
        }
        return BookIcon.from(this.indexIconRaw);
    }

    private static String numberToOrdinal(int i) {
        return i % 100 == 11 || i % 100 == 12 || i % 100 == 13 ? i + "th" : i + ORDINAL_SUFFIXES[i % 10];
    }

    public BookContents getContents() {
        if (this.isExtension) {
            return this.extensionTarget.getContents();
        }
        return this.contents != null ? this.contents : BookContents.empty(this, null);
    }
}

