/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.multiblock;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_6885;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.TriPredicate;
import vazkii.patchouli.common.multiblock.StateMatcher;

public class StringStateMatcher {
    public static IStateMatcher fromString(String s) throws CommandSyntaxException {
        if ((s = s.trim()).equals("ANY")) {
            return StateMatcher.ANY;
        }
        if (s.equals("AIR")) {
            return StateMatcher.AIR;
        }
        Either result = class_2259.method_41962((class_2378)class_2378.field_11146, (String)s, (boolean)true);
        Optional blockResult = result.left();
        Optional tagResult = result.right();
        if (blockResult.isPresent()) {
            return new ExactMatcher(((class_2259.class_7211)blockResult.get()).comp_622(), ((class_2259.class_7211)blockResult.get()).comp_623());
        }
        return new TagMatcher((class_6885<class_2248>)((class_2259.class_7212)tagResult.get()).comp_625(), ((class_2259.class_7212)tagResult.get()).comp_626());
    }

    private static class ExactMatcher
    implements IStateMatcher {
        private final class_2680 state;
        private final Map<class_2769<?>, Comparable<?>> props;

        private ExactMatcher(class_2680 state, Map<class_2769<?>, Comparable<?>> props) {
            this.state = state;
            this.props = props;
        }

        @Override
        public class_2680 getDisplayedState(long ticks) {
            return this.state;
        }

        @Override
        public TriPredicate<class_1922, class_2338, class_2680> getStatePredicate() {
            return (w, p, s) -> this.state.method_26204() == s.method_26204() && this.checkProps((class_2680)s);
        }

        private boolean checkProps(class_2680 state) {
            for (Map.Entry<class_2769<?>, Comparable<?>> e : this.props.entrySet()) {
                if (state.method_11654(e.getKey()).equals(e.getValue())) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExactMatcher that = (ExactMatcher)o;
            return Objects.equals(this.state, that.state) && Objects.equals(this.props, that.props);
        }

        public int hashCode() {
            return Objects.hash(this.state, this.props);
        }
    }

    private static class TagMatcher
    implements IStateMatcher {
        private final class_6885<class_2248> tag;
        private final Map<String, String> props;

        private TagMatcher(class_6885<class_2248> tag, Map<String, String> props) {
            this.tag = tag;
            this.props = props;
        }

        @Override
        public class_2680 getDisplayedState(long ticks) {
            if (this.tag.method_40247() == 0) {
                return class_2246.field_9987.method_9564();
            }
            int idx = (int)(ticks / 20L % (long)this.tag.method_40247());
            return ((class_2248)this.tag.method_40240(idx).comp_349()).method_9564();
        }

        @Override
        public TriPredicate<class_1922, class_2338, class_2680> getStatePredicate() {
            return (w, p, s) -> s.method_40143(this.tag) && this.checkProps((class_2680)s);
        }

        private boolean checkProps(class_2680 state) {
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                class_2769 prop = state.method_26204().method_9595().method_11663(entry.getKey());
                if (prop == null) {
                    return false;
                }
                Comparable value = prop.method_11900(entry.getValue()).orElse(null);
                if (value == null) {
                    return false;
                }
                if (state.method_11654(prop).equals(value)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TagMatcher that = (TagMatcher)o;
            return Objects.equals(this.tag, that.tag) && Objects.equals(this.props, that.props);
        }

        public int hashCode() {
            return Objects.hash(this.tag, this.props);
        }
    }
}

