/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.LiteralContents;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.text.BookTextParser;
import vazkii.patchouli.client.book.text.TextLayouter;
import vazkii.patchouli.client.book.text.Word;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;

public class BookTextRenderer {
    private final Book book;
    private final List<Word> words;
    private final float scale;

    public BookTextRenderer(GuiBook gui, Component text, int x, int y) {
        this(gui, text, x, y, 116, 9, gui.book.textColor);
    }

    public BookTextRenderer(GuiBook gui, Component text, int x, int y, int width, int lineHeight, int baseColor) {
        Component text1;
        ComponentContents componentContents;
        this.book = gui.book;
        if (this.book.i18n && (componentContents = text.m_214077_()) instanceof LiteralContents) {
            LiteralContents lc = (LiteralContents)componentContents;
            text1 = Component.m_237113_((String)I18n.m_118938_((String)lc.f_237368_(), (Object[])new Object[0]));
        } else {
            text1 = text;
        }
        Style baseStyle = this.book.getFontStyle().m_131148_(TextColor.m_131266_((int)baseColor));
        BookTextParser parser = new BookTextParser(gui, this.book, x, y, width, lineHeight, baseStyle);
        PatchouliConfig.TextOverflowMode overflowMode = this.book.overflowMode;
        if (overflowMode == null) {
            overflowMode = PatchouliConfig.get().overflowMode().get();
        }
        TextLayouter layouter = new TextLayouter(gui, x, y, lineHeight, width, overflowMode);
        layouter.layout(Minecraft.m_91087_().f_91062_, parser.parse(text1));
        this.scale = layouter.getScale();
        this.words = layouter.getWords();
    }

    private double rescale(double in, double origin) {
        return origin + (in - origin) / (double)this.scale;
    }

    public void render(PoseStack ms, int mouseX, int mouseY) {
        if (!this.words.isEmpty()) {
            Font font = Minecraft.m_91087_().f_91062_;
            Style style = this.book.getFontStyle();
            Word first = this.words.get(0);
            ms.m_85836_();
            ms.m_85837_((double)first.x, (double)first.y, 0.0);
            ms.m_85841_(this.scale, this.scale, 1.0f);
            ms.m_85837_((double)(-first.x), (double)(-first.y), 0.0);
            int scaledX = (int)this.rescale(mouseX, first.x);
            int scaledY = (int)this.rescale(mouseY, first.y);
            this.words.forEach(word -> word.render(ms, font, style, scaledX, scaledY));
            ms.m_85849_();
        }
    }

    public boolean click(double mouseX, double mouseY, int mouseButton) {
        if (!this.words.isEmpty()) {
            Word first = this.words.get(0);
            double scaledX = this.rescale(mouseX, first.x);
            double scaledY = this.rescale(mouseY, first.y);
            for (Word word : this.words) {
                if (!word.click(scaledX, scaledY, mouseButton)) continue;
                return true;
            }
        }
        return false;
    }
}

