/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.GuiBookIndex;
import vazkii.patchouli.client.book.gui.GuiBookLanding;
import vazkii.patchouli.client.book.gui.button.GuiButtonBook;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookArrow;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookBookmark;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookMarkRead;
import vazkii.patchouli.client.handler.MultiblockVisualizationHandler;
import vazkii.patchouli.client.jei.PatchouliJeiPlugin;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.mixin.client.AccessorScreen;
import vazkii.patchouli.xplat.IXplatAbstractions;

public abstract class GuiBook
extends class_437 {
    public static final int FULL_WIDTH = 272;
    public static final int FULL_HEIGHT = 180;
    public static final int PAGE_WIDTH = 116;
    public static final int PAGE_HEIGHT = 156;
    public static final int TOP_PADDING = 18;
    public static final int LEFT_PAGE_X = 15;
    public static final int RIGHT_PAGE_X = 141;
    public static final int TEXT_LINE_HEIGHT = 9;
    public static final int MAX_BOOKMARKS = 10;
    public final Book book;
    private static long lastSound;
    public int bookLeft;
    public int bookTop;
    private float scaleFactor;
    @Nullable
    private List<class_2561> tooltip;
    @Nullable
    private class_1799 tooltipStack;
    @Nullable
    private Pair<BookEntry, Integer> targetPage;
    protected int spread = 0;
    protected int maxSpreads = 0;
    public int ticksInBook;
    public int maxScale;
    protected boolean needsBookmarkUpdate = false;

    public GuiBook(Book book, class_2561 title) {
        super(title);
        this.book = book;
    }

    public void method_25426() {
        class_1041 res = this.field_22787.method_22683();
        double oldGuiScale = res.method_4476(((Integer)this.field_22787.field_1690.method_42474().method_41753()).intValue(), this.field_22787.method_1573());
        this.maxScale = this.getMaxAllowedScale();
        int persistentScale = Math.min(PersistentData.data.bookGuiScale, this.maxScale);
        double newGuiScale = res.method_4476(persistentScale, this.field_22787.method_1573());
        if (persistentScale > 0 && newGuiScale != oldGuiScale) {
            this.scaleFactor = (float)newGuiScale / (float)res.method_4495();
            res.method_15997(newGuiScale);
            this.field_22789 = res.method_4486();
            this.field_22790 = res.method_4502();
            res.method_15997(oldGuiScale);
        } else {
            this.scaleFactor = 1.0f;
        }
        this.bookLeft = this.field_22789 / 2 - 136;
        this.bookTop = this.field_22790 / 2 - 90;
        this.book.getContents().currentGui = this;
        this.method_37063(new GuiButtonBook(this, this.field_22789 / 2 - 9, this.bookTop + 180 - 5, 308, 0, 18, 9, this::canSeeBackButton, this::handleButtonBack, new class_2561[]{class_2561.method_43471((String)"patchouli.gui.lexicon.button.back"), class_2561.method_43471((String)"patchouli.gui.lexicon.button.back.info").method_27692(class_124.field_1080)}));
        this.method_37063(new GuiButtonBookArrow(this, this.bookLeft - 4, this.bookTop + 180 - 6, true));
        this.method_37063(new GuiButtonBookArrow(this, this.bookLeft + 272 - 14, this.bookTop + 180 - 6, false));
        this.addBookmarkButtons();
    }

    public class_310 getMinecraft() {
        return this.field_22787;
    }

    public final void method_25394(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        ms.method_22903();
        if (this.scaleFactor != 1.0f) {
            ms.method_22905(this.scaleFactor, this.scaleFactor, this.scaleFactor);
            mouseX = (int)((float)mouseX / this.scaleFactor);
            mouseY = (int)((float)mouseY / this.scaleFactor);
        }
        this.drawScreenAfterScale(ms, mouseX, mouseY, partialTicks);
        ms.method_22909();
    }

    private void drawScreenAfterScale(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        this.resetTooltip();
        this.method_25420(ms);
        ms.method_22903();
        ms.method_46416((float)this.bookLeft, (float)this.bookTop, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackgroundElements(ms, mouseX, mouseY, partialTicks);
        this.drawForegroundElements(ms, mouseX, mouseY, partialTicks);
        ms.method_22909();
        super.method_25394(ms, mouseX, mouseY, partialTicks);
        IXplatAbstractions.INSTANCE.fireDrawBookScreen(this.book.id, this, mouseX, mouseY, partialTicks, ms);
        this.drawTooltip(ms, mouseX, mouseY);
    }

    public void addBookmarkButtons() {
        this.removeDrawablesIf(b -> b instanceof GuiButtonBookBookmark);
        int y = 0;
        List<PersistentData.Bookmark> bookmarks = PersistentData.data.getBookData((Book)this.book).bookmarks;
        for (PersistentData.Bookmark bookmark : bookmarks) {
            this.method_37063(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + y, bookmark));
            y += 12;
        }
        if (this.shouldAddAddBookmarkButton() && bookmarks.size() <= 10) {
            this.method_37063(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + y, null));
        }
        if (MultiblockVisualizationHandler.hasMultiblock && MultiblockVisualizationHandler.bookmark != null) {
            this.method_37063(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + 156 - 20, MultiblockVisualizationHandler.bookmark, true));
        }
        if (this.shouldAddMarkReadButton()) {
            this.method_37063(new GuiButtonBookMarkRead(this, this.bookLeft + 272, this.bookTop + 18 + 156 - 10));
        }
    }

    public final void removeDrawablesIf(Predicate<class_4068> pred) {
        ((AccessorScreen)((Object)this)).getRenderables().removeIf(pred);
        this.method_25396().removeIf(listener -> {
            class_4068 w;
            return listener instanceof class_4068 && pred.test(w = (class_4068)listener);
        });
        ((AccessorScreen)((Object)this)).getNarratables().removeIf(listener -> {
            class_4068 w;
            return listener instanceof class_4068 && pred.test(w = (class_4068)listener);
        });
    }

    public final void removeDrawablesIn(Collection<?> coll) {
        this.removeDrawablesIf(coll::contains);
    }

    public <T extends class_364 & class_4068> T method_37063(T drawableElement) {
        return (T)super.method_37063(drawableElement);
    }

    public void method_25418(class_4587 matrices, @Nullable class_2583 style, int mouseX, int mouseY) {
        super.method_25418(matrices, style, mouseX, mouseY);
    }

    protected boolean shouldAddAddBookmarkButton() {
        return false;
    }

    protected boolean shouldAddMarkReadButton() {
        if (this instanceof GuiBookIndex) {
            return false;
        }
        return this.book.getContents().entries.values().stream().anyMatch(v -> !v.isLocked() && v.getReadState().equals((Object)EntryDisplayState.UNREAD));
    }

    public void bookmarkThis() {
    }

    public void onFirstOpened() {
    }

    public void method_25393() {
        if (!GuiBook.method_25442()) {
            ++this.ticksInBook;
        }
        if (this.needsBookmarkUpdate) {
            this.needsBookmarkUpdate = false;
            this.addBookmarkButtons();
        }
    }

    final void drawBackgroundElements(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        GuiBook.drawFromTexture(ms, this.book, 0, 0, 0, 0, 272, 180);
    }

    void drawForegroundElements(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
    }

    final void drawTooltip(class_4587 ms, int mouseX, int mouseY) {
        if (this.tooltipStack != null) {
            List tooltip = this.method_25408(this.tooltipStack);
            Pair<BookEntry, Integer> provider = this.book.getContents().getEntryForStack(this.tooltipStack);
            if (!(provider == null || this instanceof GuiBookEntry && ((GuiBookEntry)this).entry == provider.getFirst())) {
                class_5250 t = class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43471((String)"patchouli.gui.lexicon.shift_for_recipe")).method_27693(")").method_27692(class_124.field_1065);
                tooltip.add(t);
                this.targetPage = provider;
            }
            this.method_30901(ms, tooltip, mouseX, mouseY);
        } else if (this.tooltip != null && !this.tooltip.isEmpty()) {
            this.method_30901(ms, this.tooltip, mouseX, mouseY);
        }
    }

    final void resetTooltip() {
        this.tooltipStack = null;
        this.tooltip = null;
        this.targetPage = null;
    }

    public static void drawFromTexture(class_4587 ms, Book book, int x, int y, int u, int v, int w, int h) {
        RenderSystem.setShaderTexture((int)0, (class_2960)book.bookTexture);
        GuiBook.method_25290((class_4587)ms, (int)x, (int)y, (float)u, (float)v, (int)w, (int)h, (int)512, (int)256);
    }

    public boolean method_25421() {
        return this.book.pauseGame;
    }

    private void handleButtonBack(class_4185 button) {
        this.back(false);
    }

    public void handleButtonArrow(class_4185 button) {
        this.changePage(((GuiButtonBookArrow)button).left, false);
    }

    public void handleButtonBookmark(class_4185 button) {
        GuiButtonBookBookmark bookmarkButton = (GuiButtonBookBookmark)button;
        PersistentData.Bookmark bookmark = bookmarkButton.bookmark;
        if (bookmark == null || bookmark.getEntry(this.book) == null) {
            this.bookmarkThis();
        } else if (GuiBook.method_25442() && !bookmarkButton.multiblock) {
            List<PersistentData.Bookmark> bookmarks = PersistentData.data.getBookData((Book)this.book).bookmarks;
            bookmarks.remove(bookmark);
            PersistentData.save();
            this.needsBookmarkUpdate = true;
        } else {
            this.displayLexiconGui(new GuiBookEntry(this.book, bookmark.getEntry(this.book), bookmark.spread), true);
        }
    }

    public final boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        return this.mouseClickedScaled(mouseX / (double)this.scaleFactor, mouseY / (double)this.scaleFactor, mouseButton);
    }

    public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
        switch (mouseButton) {
            case 0: {
                if (this.targetPage == null || !GuiBook.method_25442()) break;
                this.displayLexiconGui(new GuiBookEntry(this.book, (BookEntry)this.targetPage.getFirst(), (Integer)this.targetPage.getSecond()), true);
                GuiBook.playBookFlipSound(this.book);
                return true;
            }
            case 1: {
                this.back(true);
                return true;
            }
            case 3: {
                this.changePage(true, true);
                return true;
            }
            case 4: {
                this.changePage(false, true);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_310.method_1551().field_1690.field_1822.method_1417(keyCode, scanCode) && !this.canSeeBackButton()) {
            this.method_25419();
            return true;
        }
        if (keyCode == 259) {
            this.back(true);
            return true;
        }
        if (this.tooltipStack != null && IXplatAbstractions.INSTANCE.handleRecipeKeybind(keyCode, scanCode, this.tooltipStack)) {
            return true;
        }
        if (this.tooltipStack != null && IXplatAbstractions.INSTANCE.isModLoaded("jei") && PatchouliJeiPlugin.handleRecipeKeybind(keyCode, scanCode, this.tooltipStack)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double scroll) {
        if (scroll < 0.0) {
            this.changePage(false, true);
        } else if (scroll > 0.0) {
            this.changePage(true, true);
        }
        return true;
    }

    void back(boolean sfx) {
        if (!this.book.getContents().guiStack.isEmpty()) {
            if (GuiBook.method_25442()) {
                this.displayLexiconGui(new GuiBookLanding(this.book), false);
                this.book.getContents().guiStack.clear();
            } else {
                this.displayLexiconGui(this.book.getContents().guiStack.pop(), false);
            }
            if (sfx) {
                GuiBook.playBookFlipSound(this.book);
            }
        }
    }

    void changePage(boolean left, boolean sfx) {
        if (this.canSeePageButton(left)) {
            this.spread = left ? --this.spread : ++this.spread;
            this.onPageChanged();
            if (sfx) {
                GuiBook.playBookFlipSound(this.book);
            }
        }
    }

    void onPageChanged() {
    }

    public boolean canBeOpened() {
        return true;
    }

    public boolean canSeePageButton(boolean left) {
        return left ? this.spread > 0 : this.spread + 1 < this.maxSpreads;
    }

    public boolean canSeeBackButton() {
        return !this.book.getContents().guiStack.isEmpty();
    }

    public void setTooltip(class_2561 ... strings) {
        this.setTooltip(Arrays.asList(strings));
    }

    public void setTooltip(List<class_2561> strings) {
        this.tooltip = strings;
    }

    public void setTooltipStack(class_1799 stack) {
        this.setTooltip(Collections.emptyList());
        this.tooltipStack = stack;
    }

    public boolean isMouseInRelativeRange(double absMx, double absMy, int x, int y, int w, int h) {
        double mx = this.getRelativeX(absMx);
        double my = this.getRelativeY(absMy);
        return mx > (double)x && my > (double)y && mx <= (double)(x + w) && my <= (double)(y + h);
    }

    public double getRelativeX(double absX) {
        return absX - (double)this.bookLeft;
    }

    public double getRelativeY(double absY) {
        return absY - (double)this.bookTop;
    }

    public void drawProgressBar(class_4587 ms, Book book, int mouseX, int mouseY, Predicate<BookEntry> filter) {
        if (!book.showProgress || !book.advancementsEnabled()) {
            return;
        }
        int barLeft = 19;
        int barTop = 144;
        int barWidth = 106;
        int barHeight = 12;
        int totalEntries = 0;
        int unlockedEntries = 0;
        int unlockedSecretEntries = 0;
        for (BookEntry entry : book.getContents().entries.values()) {
            if (!filter.test(entry)) continue;
            if (entry.isSecret()) {
                if (entry.isLocked()) continue;
                ++unlockedSecretEntries;
                continue;
            }
            BookCategory category = entry.getCategory();
            if (category.isSecret() && !category.isLocked()) continue;
            ++totalEntries;
            if (entry.isLocked()) continue;
            ++unlockedEntries;
        }
        float unlockFract = (float)unlockedEntries / Math.max(1.0f, (float)totalEntries);
        int progressWidth = (int)(((float)barWidth - 1.0f) * unlockFract);
        GuiBook.method_25294((class_4587)ms, (int)barLeft, (int)barTop, (int)(barLeft + barWidth), (int)(barTop + barHeight), (int)book.headerColor);
        this.drawGradient(ms, barLeft + 1, barTop + 1, barLeft + barWidth - 1, barTop + barHeight - 1, book.progressBarBackground);
        this.drawGradient(ms, barLeft + 1, barTop + 1, barLeft + progressWidth, barTop + barHeight - 1, book.progressBarColor);
        this.field_22793.method_30883(ms, (class_2561)class_2561.method_43471((String)"patchouli.gui.lexicon.progress_meter"), (float)barLeft, (float)(barTop - 9), book.headerColor);
        if (this.isMouseInRelativeRange(mouseX, mouseY, barLeft, barTop, barWidth, barHeight)) {
            ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
            class_5250 progressStr = class_2561.method_43469((String)"patchouli.gui.lexicon.progress_tooltip", (Object[])new Object[]{unlockedEntries, totalEntries});
            tooltip.add((class_2561)progressStr);
            if (unlockedSecretEntries > 0) {
                if (unlockedSecretEntries == 1) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"patchouli.gui.lexicon.progress_tooltip.secret1").method_27692(class_124.field_1080));
                } else {
                    tooltip.add((class_2561)class_2561.method_43469((String)"patchouli.gui.lexicon.progress_tooltip.secret", (Object[])new Object[]{unlockedSecretEntries}).method_27692(class_124.field_1080));
                }
            }
            if (unlockedEntries != totalEntries) {
                tooltip.add((class_2561)class_2561.method_43471((String)"patchouli.gui.lexicon.progress_tooltip.info").method_27692(class_124.field_1080));
            }
            this.setTooltip(tooltip);
        }
    }

    private void drawGradient(class_4587 ms, int x, int y, int w, int h, int color) {
        int darkerColor = new Color(color).darker().getRGB();
        this.method_25296(ms, x, y, w, h, color, darkerColor);
    }

    public void drawCenteredStringNoShadow(class_4587 ms, class_5481 s, int x, int y, int color) {
        this.field_22793.method_27528(ms, s, (float)x - (float)this.field_22793.method_30880(s) / 2.0f, (float)y, color);
    }

    public void drawCenteredStringNoShadow(class_4587 ms, String s, int x, int y, int color) {
        this.field_22793.method_1729(ms, s, (float)x - (float)this.field_22793.method_1727(s) / 2.0f, (float)y, color);
    }

    private int getMaxAllowedScale() {
        return this.field_22787.method_22683().method_4476(0, this.field_22787.method_1573());
    }

    public int getSpread() {
        return this.spread;
    }

    public static void drawSeparator(class_4587 ms, Book book, int x, int y) {
        int w = 110;
        int h = 3;
        int rx = x + 58 - w / 2;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        GuiBook.drawFromTexture(ms, book, rx, y, 140, 180, w, h);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawLock(class_4587 ms, Book book, int x, int y) {
        GuiBook.drawFromTexture(ms, book, x, y, 250, 180, 16, 16);
    }

    public static void drawMarking(class_4587 ms, Book book, int x, int y, int rand, EntryDisplayState state) {
        if (!state.hasIcon) {
            return;
        }
        RenderSystem.enableBlend();
        float alpha = state.hasAnimation ? (float)Math.sin(ClientTicker.total * 0.2f) * 0.3f + 0.7f : 1.0f;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GuiBook.drawFromTexture(ms, book, x, y, state.u, 197, 8, 8);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawPageFiller(class_4587 ms, Book book) {
        GuiBook.drawPageFiller(ms, book, 141, 18);
    }

    public static void drawPageFiller(class_4587 ms, Book book, int x, int y) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)book.fillerTexture);
        GuiBook.method_25290((class_4587)ms, (int)(x + 58 - 64), (int)(y + 78 - 74), (float)0.0f, (float)0.0f, (int)128, (int)128, (int)128, (int)128);
    }

    public static void playBookFlipSound(Book book) {
        if (ClientTicker.ticksInGame - lastSound > 6L) {
            class_3414 sfx = PatchouliSounds.getSound(book.flipSound, PatchouliSounds.BOOK_FLIP);
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)sfx, (float)((float)(0.7 + Math.random() * 0.3))));
            lastSound = ClientTicker.ticksInGame;
        }
    }

    public static void openWebLink(class_437 prevScreen, String address) {
        class_310 mc = class_310.method_1551();
        mc.method_1507((class_437)new class_407(yes -> {
            if (yes) {
                class_156.method_668().method_670(address);
            }
            mc.method_1507(prevScreen);
        }, address, false));
    }

    public void displayLexiconGui(GuiBook gui, boolean push) {
        this.book.getContents().openLexiconGui(gui, push);
    }
}

