/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookCategory;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.GuiBookHistory;
import vazkii.patchouli.client.book.gui.GuiBookIndex;
import vazkii.patchouli.client.book.gui.GuiBookWriter;
import vazkii.patchouli.client.book.gui.button.GuiButtonBook;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookResize;
import vazkii.patchouli.client.book.gui.button.GuiButtonCategory;
import vazkii.patchouli.client.book.gui.button.GuiButtonEntry;
import vazkii.patchouli.client.gui.GuiAdvancementsExt;
import vazkii.patchouli.common.book.Book;

public class GuiBookLanding
extends GuiBook {
    @Nullable
    BookTextRenderer text;
    int loadedCategories = 0;
    final List<class_4185> pamphletEntryButtons = new ArrayList<class_4185>();
    List<BookEntry> entriesInPamphlet;

    public GuiBookLanding(Book book) {
        super(book, (class_2561)class_2561.method_43471((String)book.name));
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.text = new BookTextRenderer(this, (class_2561)class_2561.method_43471((String)this.book.landingText), 15, 43);
        boolean disableBar = !this.book.showProgress || !this.book.advancementsEnabled();
        int x = this.bookLeft + (disableBar ? 25 : 20);
        int y = this.bookTop + 180 - (disableBar ? 25 : 62);
        int dist = 15;
        int pos = 0;
        if (this.maxScale > 2) {
            this.method_37063(new GuiButtonBookResize(this, x + pos++ * dist, y, this::handleButtonResize));
        }
        this.method_37063(new GuiButtonBook((GuiBook)this, x + pos++ * dist, y, 330, 31, 11, 11, this::handleButtonHistory, new class_2561[]{class_2561.method_43471((String)"patchouli.gui.lexicon.button.history")}));
        if (this.book.advancementsTab != null) {
            this.method_37063(new GuiButtonBook((GuiBook)this, x + pos++ * dist, y, 330, 20, 11, 11, this::handleButtonAdvancements, new class_2561[]{class_2561.method_43471((String)"patchouli.gui.lexicon.button.advancements")}));
        }
        if (class_310.method_1551().field_1724.method_7337()) {
            this.method_37063(new GuiButtonBook((GuiBook)this, x + pos++ * dist, y, 308, 9, 11, 11, this::handleButtonEdit, new class_2561[]{class_2561.method_43471((String)"patchouli.gui.lexicon.button.editor"), class_2561.method_43471((String)"patchouli.gui.lexicon.button.editor.info").method_27692(class_124.field_1080)}));
        }
        if (this.book.getContents().pamphletCategory == null) {
            int i = 0;
            ArrayList<BookCategory> categories = new ArrayList<BookCategory>(this.book.getContents().categories.values());
            Collections.sort(categories);
            for (BookCategory category : categories) {
                if (category.getParentCategory() != null || category.shouldHide()) continue;
                this.addCategoryButton(i, category);
                ++i;
            }
            this.addCategoryButton(i, null);
            this.loadedCategories = i + 1;
        } else {
            this.entriesInPamphlet = new ArrayList<BookEntry>(this.book.getContents().entries.values());
            this.entriesInPamphlet.removeIf(BookEntry::shouldHide);
            Collections.sort(this.entriesInPamphlet);
            this.buildEntryButtons();
            this.loadedCategories = 0;
        }
    }

    private void addCategoryButton(int i, BookCategory category) {
        int x = 151 + i % 4 * 24;
        int y = 43 + i / 4 * 24;
        if (category == null) {
            this.method_37063(new GuiButtonCategory(this, x, y, this.book.getIcon(), (class_2561)class_2561.method_43471((String)"patchouli.gui.lexicon.index"), this::handleButtonIndex));
        } else {
            this.method_37063(new GuiButtonCategory(this, x, y, category, this::handleButtonCategory));
        }
    }

    @Override
    void drawForegroundElements(class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        if (this.text != null) {
            this.text.render(ms, mouseX, mouseY);
        }
        int topSeparator = 30;
        int bottomSeparator = topSeparator + 25 + 24 * ((this.loadedCategories - 1) / 4 + 1);
        this.drawHeader(ms);
        if (this.book.getContents().pamphletCategory == null) {
            this.drawCenteredStringNoShadow(ms, class_1074.method_4662((String)"patchouli.gui.lexicon.categories", (Object[])new Object[0]), 199, 18, this.book.headerColor);
            GuiBookLanding.drawSeparator(ms, this.book, 141, topSeparator);
            if (this.loadedCategories <= 16) {
                GuiBookLanding.drawSeparator(ms, this.book, 141, bottomSeparator);
            }
        }
        if (this.book.getContents().isErrored()) {
            int x = 199;
            int y = bottomSeparator + 12;
            this.drawCenteredStringNoShadow(ms, class_1074.method_4662((String)"patchouli.gui.lexicon.loading_error", (Object[])new Object[0]), x, y, 0xFF0000);
            this.drawCenteredStringNoShadow(ms, class_1074.method_4662((String)"patchouli.gui.lexicon.loading_error_hover", (Object[])new Object[0]), x, y + 10, 0x777777);
            if (this.isMouseInRelativeRange(mouseX, mouseY, x -= 58, y -= 4, 116, 20)) {
                this.makeErrorTooltip();
            }
        }
        this.drawProgressBar(ms, this.book, mouseX, mouseY, e -> true);
    }

    @Override
    void onPageChanged() {
        this.buildEntryButtons();
    }

    private void buildEntryButtons() {
        this.removeDrawablesIn(this.pamphletEntryButtons);
        this.pamphletEntryButtons.clear();
        this.maxSpreads = 1;
        this.addEntryButtons(141, 18, 0, 11);
    }

    private void addEntryButtons(int x, int y, int start, int count) {
        if (!this.book.getContents().isErrored()) {
            for (int i = 0; i < count && i + start < this.entriesInPamphlet.size(); ++i) {
                GuiButtonEntry button = new GuiButtonEntry(this, this.bookLeft + x, this.bookTop + y + i * 11, this.entriesInPamphlet.get(start + i), this::handleButtonPamphletEntry);
                this.method_37063(button);
                this.pamphletEntryButtons.add(button);
            }
        }
    }

    private void drawHeader(class_4587 ms) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiBookLanding.drawFromTexture(ms, this.book, -8, 12, 0, 180, 140, 31);
        int color = this.book.nameplateColor;
        this.field_22793.method_30883(ms, this.book.getBookItem().method_7964(), 13.0f, 16.0f, color);
        class_5250 toDraw = this.book.getSubtitle().method_27696(this.book.getFontStyle());
        this.field_22793.method_30883(ms, (class_2561)toDraw, 24.0f, 24.0f, color);
    }

    private void makeErrorTooltip() {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        for (Throwable e = this.book.getContents().getException(); e != null; e = e.getCause()) {
            String msg = e.getMessage();
            if (msg == null || msg.isEmpty()) continue;
            lines.add((class_2561)class_2561.method_43470((String)e.getMessage()));
        }
        if (!lines.isEmpty()) {
            lines.add((class_2561)class_2561.method_43471((String)"patchouli.gui.lexicon.loading_error_log").method_27692(class_124.field_1060));
            this.setTooltip(lines);
        }
    }

    @Override
    public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
        return this.text != null && this.text.click(mouseX, mouseY, mouseButton) || super.mouseClickedScaled(mouseX, mouseY, mouseButton);
    }

    public void handleButtonIndex(class_4185 button) {
        this.displayLexiconGui(new GuiBookIndex(this.book), true);
    }

    public void handleButtonCategory(class_4185 button) {
        this.displayLexiconGui(new GuiBookCategory(this.book, ((GuiButtonCategory)button).getCategory()), true);
    }

    private void handleButtonHistory(class_4185 button) {
        this.displayLexiconGui(new GuiBookHistory(this.book), true);
    }

    private void handleButtonAdvancements(class_4185 button) {
        this.field_22787.method_1507((class_437)new GuiAdvancementsExt(this.field_22787.field_1724.field_3944.method_2869(), this, this.book.advancementsTab));
    }

    private void handleButtonEdit(class_4185 button) {
        if (GuiBookLanding.method_25442()) {
            long time = System.currentTimeMillis();
            this.book.reloadContents((class_1937)this.field_22787.field_1687, true);
            this.book.reloadLocks(false);
            this.displayLexiconGui(new GuiBookLanding(this.book), false);
            this.field_22787.field_1724.method_7353((class_2561)class_2561.method_43469((String)"patchouli.gui.lexicon.reloaded", (Object[])new Object[]{System.currentTimeMillis() - time}), false);
        } else {
            this.displayLexiconGui(new GuiBookWriter(this.book), true);
        }
    }

    public void handleButtonResize(class_4185 button) {
        PersistentData.data.bookGuiScale = PersistentData.data.bookGuiScale >= this.maxScale ? 0 : Math.max(2, PersistentData.data.bookGuiScale + 1);
        PersistentData.save();
        this.displayLexiconGui(this, false);
    }

    public void handleButtonPamphletEntry(class_4185 button) {
        GuiBookEntry.displayOrBookmark(this, ((GuiButtonEntry)button).getEntry());
    }
}

