/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.forge.common;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.command.OpenBookCommand;
import vazkii.patchouli.common.handler.LecternEventHandler;
import vazkii.patchouli.common.handler.ReloadContentsHandler;
import vazkii.patchouli.common.item.ItemModBook;
import vazkii.patchouli.common.item.PatchouliItems;
import vazkii.patchouli.forge.common.ForgePatchouliConfig;
import vazkii.patchouli.forge.network.ForgeNetworkHandler;

@Mod.EventBusSubscriber(modid="patchouli", bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="patchouli")
public class ForgeModInitializer {
    public ForgeModInitializer() {
        ForgePatchouliConfig.setup();
    }

    @SubscribeEvent
    public static void register(RegisterEvent evt) {
        evt.register(Registries.f_256840_, rh -> PatchouliSounds.submitRegistrations((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)rh).register(arg_0, arg_1)));
        evt.register(Registries.f_256913_, rh -> PatchouliItems.submitItemRegistrations((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)rh).register(arg_0, arg_1)));
        evt.register(Registries.f_256764_, rh -> PatchouliItems.submitRecipeSerializerRegistrations((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)rh).register(arg_0, arg_1)));
    }

    @SubscribeEvent
    public static void processCreativeTabs(CreativeModeTabEvent.BuildContents evt) {
        BookRegistry.INSTANCE.books.values().forEach(b -> {
            if (!b.noBook && !b.isExtension) {
                ItemStack book = ItemModBook.forBook(b);
                if (evt.getTab() == CreativeModeTabs.m_258007_()) {
                    evt.m_246342_(book);
                } else if (b.creativeTab != null) {
                    CreativeModeTab remappedVanillaTab = ForgeModInitializer.mapVanillaCreativeTabFabricIdToForge(b.creativeTab);
                    if (evt.getTab() == remappedVanillaTab || evt.getTab() == CreativeModeTabRegistry.getTab((ResourceLocation)b.creativeTab)) {
                        evt.m_246342_(book);
                    }
                }
            }
        });
    }

    @Nullable
    private static CreativeModeTab mapVanillaCreativeTabFabricIdToForge(ResourceLocation oldId) {
        if (!oldId.m_135827_().equals("minecraft")) {
            return null;
        }
        return switch (oldId.m_135815_()) {
            case "natural" -> CreativeModeTabs.f_256776_;
            case "functional" -> CreativeModeTabs.f_256791_;
            case "redstone" -> CreativeModeTabs.f_257028_;
            case "tools" -> CreativeModeTabs.f_256869_;
            case "food_and_drink" -> CreativeModeTabs.f_256839_;
            case "op" -> CreativeModeTabs.f_256837_;
            default -> null;
        };
    }

    @SubscribeEvent
    public static void onInitialize(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.addListener(e -> OpenBookCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher()));
        MinecraftForge.EVENT_BUS.addListener(e -> {
            InteractionResult result = LecternEventHandler.rightClick(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec());
            if (result.m_19077_()) {
                e.setCanceled(true);
                e.setCancellationResult(result);
            }
        });
        ForgeNetworkHandler.registerMessages();
        BookRegistry.INSTANCE.init();
        MinecraftForge.EVENT_BUS.addListener(e -> ReloadContentsHandler.dataReloaded(e.getServer()));
    }
}

