/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_7710;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.PatchouliAPI;

public class ShapelessBookRecipe
extends class_1867 {
    public static final class_1865<ShapelessBookRecipe> SERIALIZER = new Serializer();
    final String group;
    final class_1799 result;
    final class_2371<class_1856> ingredients;
    @Nullable
    final class_2960 outputBook;

    public ShapelessBookRecipe(String group, class_1799 result, class_2371<class_1856> ingredients, @Nullable class_2960 outputBook) {
        super(group, class_7710.field_40251, ShapelessBookRecipe.getOutputBook(result, outputBook), ingredients);
        this.group = group;
        this.result = result;
        this.ingredients = ingredients;
        this.outputBook = outputBook;
    }

    private static class_1799 getOutputBook(class_1799 result, @Nullable class_2960 outputBook) {
        if (outputBook != null) {
            return PatchouliAPI.get().getBookStack(outputBook);
        }
        return result;
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public static class Serializer
    implements class_1865<ShapelessBookRecipe> {
        static int maxWidth = 3;
        static int maxHeight = 3;
        private static final Codec<ShapelessBookRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.method_53049((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(bookRecipe -> bookRecipe.group), (App)class_5699.method_53049((Codec)class_1799.field_47309, (String)"result", (Object)class_1799.field_8037).forGetter(bookRecipe -> bookRecipe.result), (App)class_1856.field_46096.listOf().fieldOf("ingredients").flatXmap(ingredientList -> {
            Object[] aingredient = (class_1856[])ingredientList.toArray(class_1856[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless book recipe");
            }
            return aingredient.length > maxHeight * maxWidth ? DataResult.error(() -> "Too many ingredients for shapeless book recipe. The maximum is: %s".formatted(maxHeight * maxWidth)) : DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])aingredient));
        }, DataResult::success).forGetter(bookRecipe -> bookRecipe.ingredients), (App)class_5699.method_53049((Codec)class_2960.field_25139, (String)"book", null).forGetter(bookRecipe -> bookRecipe.outputBook)).apply((Applicative)instance, ShapelessBookRecipe::new));

        public Codec<ShapelessBookRecipe> method_53736() {
            return CODEC;
        }

        public ShapelessBookRecipe fromNetwork(class_2540 buf) {
            String group = buf.method_19772();
            int i = buf.method_10816();
            class_2371 ingredients = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)class_1856.method_8086((class_2540)buf));
            }
            class_1799 result = buf.method_10819();
            class_2960 outputBook = buf.readBoolean() ? buf.method_10810() : null;
            return new ShapelessBookRecipe(group, result, (class_2371<class_1856>)ingredients, outputBook);
        }

        public void toNetwork(class_2540 buf, ShapelessBookRecipe bookRecipe) {
            buf.method_10814(bookRecipe.group);
            buf.method_10804(bookRecipe.ingredients.size());
            for (class_1856 ingredient : bookRecipe.ingredients) {
                ingredient.method_8088(buf);
            }
            buf.method_10793(bookRecipe.result);
            buf.method_52964(bookRecipe.outputBook != null);
            if (bookRecipe.outputBook != null) {
                buf.method_10812(bookRecipe.outputBook);
            }
        }
    }
}

