/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import vazkii.patchouli.client.book.page.abstr.PageDoubleRecipeRegistry;

public class PageCrafting
extends PageDoubleRecipeRegistry<Recipe<?>> {
    public PageCrafting() {
        super(RecipeType.CRAFTING);
    }

    @Override
    protected void drawRecipe(GuiGraphics graphics, Recipe<?> recipe, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        RenderSystem.enableBlend();
        graphics.blit(this.book.craftingTexture, recipeX - 2, recipeY - 2, 0.0f, 0.0f, 100, 62, 128, 256);
        boolean shaped = recipe instanceof ShapedRecipe;
        if (!shaped) {
            int iconX = recipeX + 62;
            int iconY = recipeY + 2;
            graphics.blit(this.book.craftingTexture, iconX, iconY, 0.0f, 64.0f, 11, 11, 128, 256);
            if (this.parent.isMouseInRelativeRange(mouseX, mouseY, iconX, iconY, 11, 11)) {
                this.parent.setTooltip(new Component[]{Component.translatable((String)"patchouli.gui.lexicon.shapeless")});
            }
        }
        this.parent.drawCenteredStringNoShadow(graphics, this.getTitle(second).getVisualOrderText(), 58, recipeY - 10, this.book.headerColor);
        this.parent.renderItemStack(graphics, recipeX + 79, recipeY + 22, mouseX, mouseY, recipe.getResultItem(level.registryAccess()));
        NonNullList ingredients = recipe.getIngredients();
        int wrap = 3;
        if (shaped) {
            wrap = ((ShapedRecipe)recipe).getWidth();
        }
        for (int i = 0; i < ingredients.size(); ++i) {
            this.parent.renderIngredient(graphics, recipeX + i % wrap * 19 + 3, recipeY + i / wrap * 19 + 3, mouseX, mouseY, (Ingredient)ingredients.get(i));
        }
        this.parent.renderItemStack(graphics, recipeX + 79, recipeY + 41, mouseX, mouseY, recipe.getToastSymbol());
    }

    @Override
    protected int getRecipeHeight() {
        return 78;
    }

    @Override
    protected ItemStack getRecipeOutput(Level level, Recipe<?> recipe) {
        if (recipe == null || level == null) {
            return ItemStack.EMPTY;
        }
        return recipe.getResultItem(level.registryAccess());
    }
}

