/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.level.Level;
import vazkii.patchouli.client.book.page.abstr.PageDoubleRecipeRegistry;
import vazkii.patchouli.mixin.AccessorSmithingTransformRecipe;
import vazkii.patchouli.mixin.AccessorSmithingTrimRecipe;

public class PageSmithing
extends PageDoubleRecipeRegistry<SmithingRecipe> {
    public PageSmithing() {
        super(RecipeType.SMITHING);
    }

    @Override
    protected void drawRecipe(GuiGraphics graphics, SmithingRecipe recipe, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        RenderSystem.enableBlend();
        graphics.blit(this.book.craftingTexture, recipeX, recipeY, 11.0f, 135.0f, 96, 43, 128, 256);
        this.parent.drawCenteredStringNoShadow(graphics, this.getTitle(second).getVisualOrderText(), 58, recipeY - 10, this.book.headerColor);
        this.parent.renderIngredient(graphics, recipeX + 4, recipeY + 4, mouseX, mouseY, this.getBase(recipe));
        this.parent.renderIngredient(graphics, recipeX + 4, recipeY + 23, mouseX, mouseY, this.getAddition(recipe));
        this.parent.renderItemStack(graphics, recipeX + 40, recipeY + 13, mouseX, mouseY, recipe.getToastSymbol());
        this.parent.renderItemStack(graphics, recipeX + 76, recipeY + 13, mouseX, mouseY, recipe.getResultItem(level.registryAccess()));
    }

    private Ingredient getBase(SmithingRecipe recipe) {
        if (recipe instanceof SmithingTrimRecipe) {
            return ((AccessorSmithingTrimRecipe)recipe).getBase();
        }
        if (recipe instanceof SmithingTransformRecipe) {
            return ((AccessorSmithingTransformRecipe)recipe).getBase();
        }
        return Ingredient.EMPTY;
    }

    private Ingredient getAddition(SmithingRecipe recipe) {
        if (recipe instanceof SmithingTrimRecipe) {
            return ((AccessorSmithingTrimRecipe)recipe).getAddition();
        }
        if (recipe instanceof SmithingTransformRecipe) {
            return ((AccessorSmithingTransformRecipe)recipe).getAddition();
        }
        return Ingredient.EMPTY;
    }

    private Ingredient getTemplate(SmithingRecipe recipe) {
        if (recipe instanceof SmithingTrimRecipe) {
            return ((AccessorSmithingTrimRecipe)recipe).getTemplate();
        }
        if (recipe instanceof SmithingTransformRecipe) {
            return ((AccessorSmithingTransformRecipe)recipe).getTemplate();
        }
        return Ingredient.EMPTY;
    }

    @Override
    protected ItemStack getRecipeOutput(Level level, SmithingRecipe recipe) {
        if (recipe == null || level == null) {
            return ItemStack.EMPTY;
        }
        return recipe.getResultItem(level.registryAccess());
    }

    @Override
    protected int getRecipeHeight() {
        return 60;
    }
}

