/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.PatchouliAPI;

public class ShapelessBookRecipe
extends ShapelessRecipe {
    public static final RecipeSerializer<ShapelessBookRecipe> SERIALIZER = new Serializer();
    final String group;
    final ItemStack result;
    final NonNullList<Ingredient> ingredients;
    @Nullable
    final ResourceLocation outputBook;

    public ShapelessBookRecipe(String group, ItemStack result, NonNullList<Ingredient> ingredients, @Nullable ResourceLocation outputBook) {
        super(group, CraftingBookCategory.MISC, ShapelessBookRecipe.getOutputBook(result, outputBook), ingredients);
        this.group = group;
        this.result = result;
        this.ingredients = ingredients;
        this.outputBook = outputBook;
    }

    private static ItemStack getOutputBook(ItemStack result, @Nullable ResourceLocation outputBook) {
        if (outputBook != null) {
            return PatchouliAPI.get().getBookStack(outputBook);
        }
        return result;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessBookRecipe> {
        static int maxWidth = 3;
        static int maxHeight = 3;
        private static final Codec<ShapelessBookRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(bookRecipe -> bookRecipe.group), (App)ExtraCodecs.strictOptionalField((Codec)ItemStack.ITEM_WITH_COUNT_CODEC, (String)"result", (Object)ItemStack.EMPTY).forGetter(bookRecipe -> bookRecipe.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(ingredientList -> {
            Object[] aingredient = (Ingredient[])ingredientList.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless book recipe");
            }
            return aingredient.length > maxHeight * maxWidth ? DataResult.error(() -> "Too many ingredients for shapeless book recipe. The maximum is: %s".formatted(maxHeight * maxWidth)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(bookRecipe -> bookRecipe.ingredients), (App)ExtraCodecs.strictOptionalField((Codec)ResourceLocation.CODEC, (String)"book", null).forGetter(bookRecipe -> bookRecipe.outputBook)).apply((Applicative)instance, ShapelessBookRecipe::new));

        public Codec<ShapelessBookRecipe> codec() {
            return CODEC;
        }

        public ShapelessBookRecipe fromNetwork(FriendlyByteBuf buf) {
            String group = buf.readUtf();
            int i = buf.readVarInt();
            NonNullList ingredients = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.fromNetwork((FriendlyByteBuf)buf));
            }
            ItemStack result = buf.readItem();
            ResourceLocation outputBook = buf.readBoolean() ? buf.readResourceLocation() : null;
            return new ShapelessBookRecipe(group, result, (NonNullList<Ingredient>)ingredients, outputBook);
        }

        public void toNetwork(FriendlyByteBuf buf, ShapelessBookRecipe bookRecipe) {
            buf.writeUtf(bookRecipe.group);
            buf.writeVarInt(bookRecipe.ingredients.size());
            for (Ingredient ingredient : bookRecipe.ingredients) {
                ingredient.toNetwork(buf);
            }
            buf.writeItem(bookRecipe.result);
            buf.writeBoolean(bookRecipe.outputBook != null);
            if (bookRecipe.outputBook != null) {
                buf.writeResourceLocation(bookRecipe.outputBook);
            }
        }
    }
}

