/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.neoforge.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public record NeoForgeMessageOpenBookGui(ResourceLocation book, @Nullable ResourceLocation entry, int page) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("patchouli", "open_book");

    public NeoForgeMessageOpenBookGui(FriendlyByteBuf buf) {
        this(buf.readResourceLocation(), NeoForgeMessageOpenBookGui.getEntry(buf), buf.readVarInt());
    }

    private static ResourceLocation getEntry(FriendlyByteBuf buf) {
        String entry = buf.readUtf();
        return entry.isEmpty() ? null : new ResourceLocation(entry);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeResourceLocation(this.book);
        buf.writeUtf(this.entry == null ? "" : this.entry.toString());
        buf.writeVarInt(this.page);
    }

    public static void send(ServerPlayer player, ResourceLocation book, @Nullable ResourceLocation entry, int page) {
        player.connection.send((CustomPacketPayload)new NeoForgeMessageOpenBookGui(book, entry, page));
    }

    public ResourceLocation id() {
        return ID;
    }
}

