/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.client.render.tile;

import com.breakinblocks.plonk.common.block.BlockPlacedItems;
import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import com.breakinblocks.plonk.common.util.MatrixUtils;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class TESRPlacedItems
extends TileEntitySpecialRenderer<TilePlacedItems> {
    public static final PropertyDirection FACING = BlockPlacedItems.FACING;
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final RenderItem renderItem = mc.func_175599_af();
    private static final Tessellator tessellator = Tessellator.func_178181_a();
    private static final BufferBuilder bufferbuilder = tessellator.func_178180_c();
    private static final BlockRendererDispatcher blockRendererDispatcher = mc.func_175602_ab();

    public static int getRenderTypeFromStack(ItemStack itemstack) {
        Matrix4f matrixGui;
        IBakedModel model = renderItem.func_184393_a(itemstack, null, null);
        Matrix4f matrixFixed = (Matrix4f)model.handlePerspective(ItemCameraTransforms.TransformType.FIXED).getRight();
        if (matrixFixed == null) {
            matrixFixed = new Matrix4f();
            matrixFixed.setIdentity();
        }
        if ((matrixGui = (Matrix4f)model.handlePerspective(ItemCameraTransforms.TransformType.GUI).getRight()) == null) {
            matrixGui = new Matrix4f();
            matrixGui.setIdentity();
        }
        Matrix4d difference = MatrixUtils.difference(new Matrix4d(matrixFixed), new Matrix4d(matrixGui));
        MatrixUtils.TransformData transform = new MatrixUtils.TransformData(difference);
        double hS = Math.abs((transform.sx + transform.sy + transform.sz) / 3.0);
        double hRotP = (360.0 + transform.pitch) % 90.0;
        hRotP = Math.min(Math.abs(hRotP), Math.abs(hRotP - 90.0));
        double hRotY = (360.0 + transform.yaw) % 90.0;
        hRotY = Math.min(Math.abs(hRotY), Math.abs(hRotY - 90.0));
        double hRotR = (360.0 + transform.roll) % 90.0;
        hRotR = Math.min(Math.abs(hRotR), Math.abs(hRotR - 90.0));
        double hRot = hRotP + hRotY + hRotR;
        return hS > 0.999 && hRot > 0.001 ? 1 : 0;
    }

    public void render(TilePlacedItems te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState state;
        EnumFacing facing = EnumFacing.UP;
        if (te.func_145830_o() && (state = this.func_178459_a().func_180495_p(te.func_174877_v())).func_177230_c() instanceof BlockPlacedItems) {
            facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        switch (facing) {
            case UP: {
                break;
            }
            case DOWN: {
                GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case SOUTH: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case NORTH: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case EAST: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case WEST: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
            }
        }
        GL11.glTranslated((double)0.0, (double)-0.5, (double)0.0);
        GL11.glRotated((double)(-te.getTileRotationAngle()), (double)0.0, (double)1.0, (double)0.0);
        ItemStack[] contents = te.getContentsDisplay();
        TilePlacedItems.ItemMeta[] contentsMeta = te.getContentsMeta();
        int num = contents.length;
        if (num > 0) {
            boolean halfSize = num > 1;
            for (int slot = 0; slot < num; ++slot) {
                ItemStack stack = te.func_70301_a(slot);
                if (stack.func_190926_b()) continue;
                GL11.glPushMatrix();
                switch (num) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (slot == 0) {
                            GL11.glTranslated((double)-0.25, (double)0.0, (double)0.0);
                            break;
                        }
                        GL11.glTranslated((double)0.25, (double)0.0, (double)0.0);
                        break;
                    }
                    default: {
                        boolean left = slot % 2 == 0;
                        boolean top = slot / 2 == 0;
                        GL11.glTranslated((double)(left ? -0.25 : 0.25), (double)0.0, (double)(top ? -0.25 : 0.25));
                    }
                }
                this.renderStack(te.func_145831_w(), stack, contentsMeta[slot], partialTicks, halfSize);
                GL11.glPopMatrix();
            }
        }
        GL11.glPopMatrix();
    }

    public void renderStack(World world, ItemStack stack, TilePlacedItems.ItemMeta meta, float partialTicks, boolean halfSize) {
        GlStateManager.func_179094_E();
        GL11.glRotated((double)(-meta.getRotationAngle()), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        switch (meta.renderType) {
            case 1: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.25f, (float)0.0f);
                renderItem.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                break;
            }
            default: {
                GlStateManager.func_179109_b((float)0.0f, (float)0.041666668f, (float)0.0f);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                if (halfSize) {
                    GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                }
                renderItem.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
            }
        }
        GlStateManager.func_179121_F();
    }
}

