/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.item;

import com.breakinblocks.plonk.common.registry.RegistryBlocks;
import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemBlockPlacedItems
extends ItemBlock {
    private static final String TAG_HELD = "Held";
    private static final String TAG_RENDER_TYPE = "RenderType";

    public ItemBlockPlacedItems() {
        super((Block)RegistryBlocks.placed_items);
    }

    public void setHeldStack(ItemStack stack, ItemStack held, int renderType) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        NBTTagCompound tagCompoundHeld = tagCompound.func_74775_l(TAG_HELD);
        held.func_77955_b(tagCompoundHeld);
        tagCompound.func_74782_a(TAG_HELD, (NBTBase)tagCompoundHeld);
        tagCompound.func_74768_a(TAG_RENDER_TYPE, renderType);
        stack.func_77982_d(tagCompound);
    }

    public ItemStack getHeldStack(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(tagCompound.func_74775_l(TAG_HELD));
    }

    public int getHeldRenderType(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e(TAG_RENDER_TYPE);
    }

    protected boolean tryInsertStack(ItemStack placerStack, TilePlacedItems tile, EntityPlayer player) {
        ItemStack heldItem = this.getHeldStack(placerStack);
        int renderType = this.getHeldRenderType(placerStack);
        ItemStack remainder = tile.insertStack(heldItem, renderType);
        tile.func_70296_d();
        tile.clean();
        if (remainder != heldItem) {
            this.setHeldStack(placerStack, remainder, renderType);
            return true;
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack placerStack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (this.getHeldStack(placerStack).func_190926_b()) {
            return EnumActionResult.FAIL;
        }
        TilePlacedItems tile = null;
        if (world.func_180495_p(pos).func_177230_c() == RegistryBlocks.placed_items) {
            tile = (TilePlacedItems)world.func_175625_s(pos);
        } else {
            BlockPos pos2 = pos.func_177972_a(facing);
            if (world.func_180495_p(pos2).func_177230_c() == RegistryBlocks.placed_items) {
                tile = (TilePlacedItems)world.func_175625_s(pos2);
            }
        }
        if (tile != null && this.tryInsertStack(placerStack, tile, player)) {
            IBlockState state = world.func_180495_p(pos);
            SoundType soundtype = state.func_177230_c().getSoundType(state, world, pos, (Entity)player);
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ) == EnumActionResult.SUCCESS ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }

    public boolean placeBlockAt(ItemStack placerStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (this.getHeldStack(placerStack).func_190926_b()) {
            return false;
        }
        if (!super.placeBlockAt(placerStack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            return false;
        }
        TilePlacedItems tile = (TilePlacedItems)world.func_175625_s(pos);
        if (tile == null) {
            return false;
        }
        return this.tryInsertStack(placerStack, tile, player);
    }
}

