/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.util.bound;

import com.breakinblocks.plonk.common.util.bound.Box;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class BoxCollection {
    private final ArrayList<Entry> boxes;
    private final ArrayList<Entry> collisionBoxes;
    private final ArrayList<Entry> selectionBoxes;
    private final Box renderBox;
    private Entry selectionLastEntry = null;
    private AxisAlignedBB selectionLastAABB = null;
    private Entry boundsEntry = null;

    private BoxCollection(ArrayList<Entry> boxes) {
        this.boxes = new ArrayList<Entry>(boxes);
        this.collisionBoxes = this.boxes.stream().filter(entry -> entry.collision).collect(Collectors.toCollection(ArrayList::new));
        this.selectionBoxes = this.boxes.stream().filter(entry -> entry.selection).collect(Collectors.toCollection(ArrayList::new));
        this.renderBox = this.boxes.stream().map(entry -> entry.box).reduce(Box::enclosing).orElse(Box.BLOCK_BOX);
    }

    public int size() {
        return this.boxes.size();
    }

    public ArrayList<Box> get(int id) {
        return this.boxes.stream().filter(e -> e.id == id).map(e -> e.box).collect(Collectors.toCollection(ArrayList::new));
    }

    public void addCollidingBoxes(BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes) {
        for (Entry entry : this.collisionBoxes) {
            AxisAlignedBB blockBox;
            if (!entry.collision || !(blockBox = entry.box.toAABB().func_186670_a(pos)).func_72326_a(entityBox)) continue;
            collidingBoxes.add(blockBox);
        }
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        if (this.selectionLastAABB == null) {
            return this.renderBox.toAABB();
        }
        return this.selectionLastAABB;
    }

    public int getSelectedId() {
        return this.selectionLastEntry == null ? -1 : this.selectionLastEntry.id;
    }

    public RayTraceResult collisionRayTrace(Block block, ICollisionRayTrace collisionRayTrace, IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        int num = this.boxes.size();
        RayTraceResult[] mops = new RayTraceResult[num];
        for (int i = 0; i < num; ++i) {
            this.boundsEntry = this.boxes.get(i);
            mops[i] = collisionRayTrace.apply(blockState, worldIn, pos, start, end);
        }
        this.boundsEntry = null;
        int nearestMopIndex = -1;
        double minDistSq = Double.POSITIVE_INFINITY;
        for (int i = 0; i < num; ++i) {
            double distSq;
            RayTraceResult mop = mops[i];
            if (mop == null || !((distSq = mop.field_72307_f.func_72436_e(start)) < minDistSq)) continue;
            minDistSq = distSq;
            nearestMopIndex = i;
        }
        if (nearestMopIndex >= 0) {
            this.selectionLastEntry = this.boxes.get(nearestMopIndex);
            this.selectionLastAABB = this.selectionLastEntry.box.toAABB().func_186670_a(pos);
        } else {
            this.selectionLastEntry = null;
            this.selectionLastAABB = null;
        }
        return nearestMopIndex < 0 ? null : mops[nearestMopIndex];
    }

    public AxisAlignedBB getBoundingBox(BlockPos pos) {
        if (this.boundsEntry != null) {
            return this.boundsEntry.box.toAABB();
        }
        return this.renderBox.toAABB();
    }

    public static class Builder {
        private ArrayList<Entry> boxes = new ArrayList();
        private boolean collision;
        private boolean selection;

        public Builder(boolean collision, boolean selection) {
            this.collision = collision;
            this.selection = selection;
        }

        public Builder() {
            this(true, true);
        }

        public Builder setCollision(boolean collision) {
            this.collision = collision;
            return this;
        }

        public Builder setSelection(boolean selection) {
            this.selection = selection;
            return this;
        }

        public Builder addBox(int id, Box box) {
            this.boxes.add(new Entry(id, this.collision, this.selection, box));
            return this;
        }

        public Builder addBox(int id, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            return this.addBox(id, new Box(minX, minY, minZ, maxX, maxY, maxZ));
        }

        public Builder addBoxes(BoxCollection boxCollection) {
            this.boxes.addAll(boxCollection.boxes);
            return this;
        }

        public Builder apply(Function<Box, Box> transform) {
            this.boxes = this.boxes.stream().map(e -> new Entry(e.id, e.collision, e.selection, (Box)transform.apply(e.box))).collect(Collectors.toCollection(ArrayList::new));
            return this;
        }

        public BoxCollection build() {
            BoxCollection boxCollection = new BoxCollection(this.boxes);
            return boxCollection;
        }
    }

    public static class Entry {
        public final int id;
        public final boolean collision;
        public final boolean selection;
        public final Box box;

        public Entry(int id, boolean collision, boolean selection, Box box) {
            this.id = id;
            this.collision = collision;
            this.selection = selection;
            this.box = box;
        }
    }

    @FunctionalInterface
    public static interface IAddCollisionBoxesToList {
        public void apply(World var1, int var2, int var3, int var4, AxisAlignedBB var5, List var6, Entity var7);
    }

    @FunctionalInterface
    public static interface ICollisionRayTrace {
        public RayTraceResult apply(IBlockState var1, World var2, BlockPos var3, Vec3d var4, Vec3d var5);
    }
}

