/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.client.command;

import com.breakinblocks.plonk.client.render.tile.TESRPlacedItems;
import com.breakinblocks.plonk.client.util.RenderUtils;
import com.breakinblocks.plonk.common.command.IPlonkCommand;
import com.breakinblocks.plonk.common.util.MatrixUtils;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandDumpRenderTypes
implements IPlonkCommand {
    private static final Logger LOG = LogManager.getLogger();
    private static final ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();

    private static LinkedHashSet<ItemStackRef> getAllStacks() {
        LinkedHashSet<ItemStackRef> items = new LinkedHashSet<ItemStackRef>();
        ForgeRegistries.BLOCKS.forEach(block -> items.addAll(CommandDumpRenderTypes.getAllStacks(Item.func_150898_a((Block)block))));
        ForgeRegistries.ITEMS.forEach(item -> items.addAll(CommandDumpRenderTypes.getAllStacks(item)));
        return items;
    }

    private static List<ItemStackRef> getAllStacks(Item item) {
        NonNullList subItems = NonNullList.func_191196_a();
        item.func_150895_a(ItemGroup.field_78027_g, subItems);
        return subItems.stream().map(ItemStackRef::new).collect(Collectors.toList());
    }

    private static String describeStack(ItemStack stack) {
        StringBuilder build = new StringBuilder();
        build.append(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.func_77973_b()));
        Optional.ofNullable(stack.func_77978_p()).ifPresent(build::append);
        return build.toString();
    }

    private static Stream<Map.Entry<String, String>> getRenderData(ItemStack stack) {
        IBakedModel model = itemRenderer.func_184393_a(stack, null, null);
        ItemCameraTransforms.TransformType[] types = new ItemCameraTransforms.TransformType[]{ItemCameraTransforms.TransformType.FIXED, ItemCameraTransforms.TransformType.GUI};
        Map baseTransforms = Arrays.stream(types).collect(Collectors.toMap(type -> type.name().toLowerCase(Locale.ROOT), type -> new Matrix4f(RenderUtils.getModelTransformMatrix(model, type)), (a, b) -> b, LinkedHashMap::new));
        LinkedHashMap<String, Matrix4f> transforms = new LinkedHashMap<String, Matrix4f>();
        transforms.put("fixed->gui", MatrixUtils.difference((Matrix4f)baseTransforms.get("fixed"), (Matrix4f)baseTransforms.get("gui")));
        transforms.putAll(baseTransforms);
        return transforms.entrySet().stream().flatMap(kv -> {
            String transformName = (String)kv.getKey();
            return CommandDumpRenderTypes.describeTransform((Matrix4f)kv.getValue()).entrySet().stream().map(e -> new AbstractMap.SimpleEntry(transformName + "." + (String)e.getKey(), e.getValue()));
        });
    }

    private static LinkedHashMap<String, String> describeTransform(Matrix4f mat) {
        MatrixUtils.TransformData transform = new MatrixUtils.TransformData(mat);
        LinkedHashMap<String, String> description = new LinkedHashMap<String, String>();
        description.put("tx", String.valueOf(transform.tx));
        description.put("ty", String.valueOf(transform.ty));
        description.put("tz", String.valueOf(transform.tz));
        description.put("sx", String.valueOf(transform.sx));
        description.put("sy", String.valueOf(transform.sy));
        description.put("sz", String.valueOf(transform.sz));
        description.put("yaw", String.valueOf(transform.yaw));
        description.put("pitch", String.valueOf(transform.pitch));
        description.put("roll", String.valueOf(transform.roll));
        double hS = Math.abs((double)(transform.sx + transform.sy + transform.sz) / 3.0);
        double hRotP = (360.0 + transform.pitch) % 90.0;
        hRotP = Math.min(Math.abs(hRotP), Math.abs(hRotP - 90.0));
        double hRotY = (360.0 + transform.yaw) % 90.0;
        hRotY = Math.min(Math.abs(hRotY), Math.abs(hRotY - 90.0));
        double hRotR = (360.0 + transform.roll) % 90.0;
        hRotR = Math.min(Math.abs(hRotR), Math.abs(hRotR - 90.0));
        double hRot = hRotP + hRotY + hRotR;
        description.put("hS", String.valueOf(hS));
        description.put("hRot", String.valueOf(hRot));
        return description;
    }

    @Override
    public String getName() {
        return "dumprt";
    }

    @Override
    public String getUsage(CommandSource sender) {
        return "/cplonk dumprt - Dumps render type information";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)this.getName()).requires(source -> source.func_197034_c(this.getRequiredPermissionLevel()))).executes(context -> this.execute((CommandSource)context.getSource()));
    }

    private int execute(CommandSource sender) {
        LinkedListMultimap data = LinkedListMultimap.create();
        String[] renderDataHeadersTemp = new String[]{""};
        CommandDumpRenderTypes.getAllStacks().stream().map(ref -> ref.stack).forEachOrdered(arg_0 -> CommandDumpRenderTypes.lambda$execute$11(renderDataHeadersTemp, (Multimap)data, arg_0));
        String renderDataHeaders = renderDataHeadersTemp[0];
        if (data.isEmpty()) {
            sender.func_197021_a((ITextComponent)new StringTextComponent("No data"));
            return 0;
        }
        StringBuilder output = new StringBuilder();
        output.append("stacks\t");
        output.append(renderDataHeaders);
        data.keySet().forEach(arg_0 -> CommandDumpRenderTypes.lambda$execute$12(output, (Multimap)data, arg_0));
        LOG.info((CharSequence)output);
        sender.func_197030_a((ITextComponent)new StringTextComponent("Render Type Data dumped (see logs)\nUnique transforms: " + data.keySet().size() + "\nNum Stacks: " + data.size()), true);
        return 1;
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    private static /* synthetic */ void lambda$execute$12(StringBuilder output, Multimap data, String k) {
        output.append("\n").append(String.join((CharSequence)",", data.get((Object)k))).append("\t").append(k);
    }

    private static /* synthetic */ void lambda$execute$11(String[] renderDataHeadersTemp, Multimap data, ItemStack stack) {
        LinkedHashMap renderData = Stream.concat(Stream.of(new AbstractMap.SimpleEntry<String, String>("renderType", String.valueOf(TESRPlacedItems.getRenderTypeFromStack(stack)))), CommandDumpRenderTypes.getRenderData(stack)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
        if (renderDataHeadersTemp[0].isEmpty()) {
            renderDataHeadersTemp[0] = String.join((CharSequence)"\t", renderData.keySet());
        }
        data.put((Object)String.join((CharSequence)"\t", renderData.values()), (Object)CommandDumpRenderTypes.describeStack(stack));
    }

    private static class ItemStackRef {
        public final ItemStack stack;

        public ItemStackRef(Item item) {
            this(new ItemStack((IItemProvider)item));
        }

        public ItemStackRef(ItemStack stack) {
            this.stack = stack.func_77946_l();
            this.stack.func_190920_e(Math.min(stack.func_190916_E(), 1));
        }

        public int hashCode() {
            int result = this.stack.func_77973_b().hashCode();
            CompoundNBT tag = this.stack.func_77978_p();
            result = 31 * result + (tag == null ? 7 : tag.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ItemStackRef)) {
                return false;
            }
            ItemStackRef o = (ItemStackRef)obj;
            if (this.stack.func_77973_b() != o.stack.func_77973_b()) {
                return false;
            }
            return Objects.equals(this.stack.func_77978_p(), o.stack.func_77978_p());
        }
    }
}

