/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.client.render.tile;

import com.breakinblocks.plonk.client.util.RenderUtils;
import com.breakinblocks.plonk.common.block.BlockPlacedItems;
import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import com.breakinblocks.plonk.common.util.MatrixUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.vecmath.Matrix4f;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;

public class TESRPlacedItems
extends TileEntityRenderer<TilePlacedItems> {
    public static final DirectionProperty FACING = BlockPlacedItems.FACING;
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final ItemRenderer itemRenderer = mc.func_175599_af();
    private static final Tessellator tessellator = Tessellator.func_178181_a();
    private static final BufferBuilder bufferbuilder = tessellator.func_178180_c();
    private static final BlockRendererDispatcher blockRendererDispatcher = mc.func_175602_ab();
    private static final double EPS = 0.001;

    public static int getRenderTypeFromStack(ItemStack itemstack) {
        IBakedModel model = itemRenderer.func_184393_a(itemstack, null, null);
        Matrix4f matrixFixed = RenderUtils.getModelTransformMatrix(model, ItemCameraTransforms.TransformType.FIXED);
        Matrix4f matrixGui = RenderUtils.getModelTransformMatrix(model, ItemCameraTransforms.TransformType.GUI);
        Matrix4f difference = MatrixUtils.difference(matrixFixed, matrixGui);
        MatrixUtils.TransformData transform = new MatrixUtils.TransformData(difference);
        double hS = Math.abs((double)(transform.sx + transform.sy + transform.sz) / 3.0);
        double hRotP = (360.0 + transform.pitch) % 90.0;
        hRotP = Math.min(Math.abs(hRotP), Math.abs(hRotP - 90.0));
        double hRotY = (360.0 + transform.yaw) % 90.0;
        hRotY = Math.min(Math.abs(hRotY), Math.abs(hRotY - 90.0));
        double hRotR = (360.0 + transform.roll) % 90.0;
        hRotR = Math.min(Math.abs(hRotR), Math.abs(hRotR - 90.0));
        double hRot = hRotP + hRotY + hRotR;
        double blockRot = 83.80586;
        if (83.80485999999999 <= hRot && hRot <= 83.80686) {
            return 1;
        }
        return 0;
    }

    public void render(TilePlacedItems tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        BlockState blockstate;
        Direction facing = Direction.UP;
        if (tileEntityIn.func_145830_o() && (blockstate = tileEntityIn.func_195044_w()).func_177230_c() instanceof BlockPlacedItems) {
            facing = (Direction)blockstate.func_177229_b((IProperty)FACING);
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        switch (facing) {
            case UP: {
                break;
            }
            case DOWN: {
                GlStateManager.rotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                GlStateManager.rotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case SOUTH: {
                GlStateManager.rotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case NORTH: {
                GlStateManager.rotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GlStateManager.rotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case EAST: {
                GlStateManager.rotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GlStateManager.rotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case WEST: {
                GlStateManager.rotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GlStateManager.rotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
            }
        }
        GlStateManager.translated((double)0.0, (double)-0.5, (double)0.0);
        GlStateManager.rotated((double)(-tileEntityIn.getTileRotationAngle()), (double)0.0, (double)1.0, (double)0.0);
        ItemStack[] contents = tileEntityIn.getContentsDisplay();
        TilePlacedItems.ItemMeta[] contentsMeta = tileEntityIn.getContentsMeta();
        int num = contents.length;
        if (num > 0) {
            boolean halfSize = num > 1;
            for (int slot = 0; slot < num; ++slot) {
                ItemStack stack = tileEntityIn.func_70301_a(slot);
                if (stack.func_190926_b()) continue;
                GlStateManager.pushMatrix();
                switch (num) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (slot == 0) {
                            GlStateManager.translated((double)-0.25, (double)0.0, (double)0.0);
                            break;
                        }
                        GlStateManager.translated((double)0.25, (double)0.0, (double)0.0);
                        break;
                    }
                    default: {
                        boolean left = slot % 2 == 0;
                        boolean top = slot / 2 == 0;
                        GlStateManager.translated((double)(left ? -0.25 : 0.25), (double)0.0, (double)(top ? -0.25 : 0.25));
                    }
                }
                this.renderStack(partialTicks, stack, contentsMeta[slot], halfSize);
                GlStateManager.popMatrix();
            }
        }
        GlStateManager.popMatrix();
    }

    public void renderStack(float partialTicks, ItemStack stack, TilePlacedItems.ItemMeta meta, boolean halfSize) {
        if (stack.func_190926_b()) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.rotated((double)(-meta.getRotationAngle()), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        switch (meta.renderType) {
            case 1: {
                GlStateManager.translatef((float)0.0f, (float)0.25f, (float)0.0f);
                itemRenderer.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                break;
            }
            default: {
                GlStateManager.translatef((float)0.0f, (float)0.041666668f, (float)0.0f);
                GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                if (halfSize) {
                    GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
                }
                itemRenderer.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
            }
        }
        GlStateManager.popMatrix();
    }
}

