/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.block;

import com.breakinblocks.plonk.common.registry.RegistryTileEntities;
import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import com.breakinblocks.plonk.common.util.ItemUtils;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockPlacedItems
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private final ThreadLocal<Boolean> picking = ThreadLocal.withInitial(() -> false);

    public BlockPlacedItems(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.UP));
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.func_204507_t(state).func_206888_e();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        TilePlacedItems tile = (TilePlacedItems)worldIn.func_175625_s(pos);
        if (tile == null) {
            return VoxelShapes.func_197880_a();
        }
        if (this.picking.get().booleanValue()) {
            return tile.getContentsBoxes().getSelectionShape();
        }
        int slot = -1;
        Entity entity = context.getEntity();
        if (entity instanceof LivingEntity) {
            slot = this.getPickedSlot(worldIn, pos, (LivingEntity)entity);
        }
        return slot >= 0 ? tile.getContentsBoxes().getSelectionShapeById(slot + 1) : tile.getContentsBoxes().getSelectionShape();
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        TilePlacedItems tile = (TilePlacedItems)worldIn.func_175625_s(pos);
        return tile != null ? tile.getContentsBoxes().getCollisionShape() : VoxelShapes.func_197880_a();
    }

    @Deprecated
    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        IFluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)direction)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof IInventory) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPickedSlot(IBlockReader worldIn, BlockPos pos, LivingEntity player) {
        RayTraceResult traceResult;
        if (this.picking.get().booleanValue()) {
            return -1;
        }
        double blockReachDistance = Objects.requireNonNull(player.func_110148_a(PlayerEntity.REACH_DISTANCE)).func_111126_e();
        float partialTicks = 0.0f;
        try {
            this.picking.set(true);
            traceResult = player.func_213324_a(blockReachDistance, partialTicks, false);
        }
        finally {
            this.picking.set(false);
        }
        if (traceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Vec3d hitVec = traceResult.func_216347_e().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            TilePlacedItems tile = (TilePlacedItems)worldIn.func_175625_s(pos);
            Objects.requireNonNull(tile);
            int index = tile.getContentsBoxes().getSelectionIndexFromHitVec(hitVec);
            return index <= 0 ? 0 : index - 1;
        }
        return -1;
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return true;
        }
        int slot = this.getPickedSlot((IBlockReader)worldIn, pos, (LivingEntity)player);
        if (slot >= 0) {
            TilePlacedItems tile = (TilePlacedItems)worldIn.func_175625_s(pos);
            Objects.requireNonNull(tile);
            ItemStack stack = tile.func_70301_a(slot);
            if (!stack.func_190926_b()) {
                if (player.func_70093_af()) {
                    tile.rotateSlot(slot);
                } else {
                    ItemUtils.dropItemOnEntity((LivingEntity)player, stack);
                    tile.func_70299_a(slot, ItemStack.field_190927_a);
                }
                tile.func_70296_d();
                tile.clean();
            }
            return true;
        }
        return super.func_220051_a(state, worldIn, pos, player, handIn, hit);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{FACING, WATERLOGGED});
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (placer == null) {
            return;
        }
        Direction facing = (Direction)worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING);
        TilePlacedItems tile = (TilePlacedItems)worldIn.func_175625_s(pos);
        float yaw = placer.field_70177_z % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        int rotation = Math.round(yaw / 90.0f) % 4;
        rotation = facing == Direction.UP ? (rotation + 2) % 4 : (facing == Direction.DOWN ? 4 - rotation : 0);
        tile.setTileRotation(rotation);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return RegistryTileEntities.placed_items.func_200968_a();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TilePlacedItems tile = (TilePlacedItems)world.func_175625_s(pos);
        if (tile == null) {
            return ItemStack.field_190927_a;
        }
        int slot = this.getPickedSlot(world, pos, (LivingEntity)player);
        return slot >= 0 ? tile.func_70301_a(slot) : ItemStack.field_190927_a;
    }

    public boolean addLandingEffects(BlockState state1, ServerWorld worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public boolean addRunningEffects(BlockState state, World world, BlockPos pos, Entity entity) {
        return true;
    }

    public boolean addHitEffects(BlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return super.getSoundType(state, world, pos, entity);
    }
}

