/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.item;

import com.breakinblocks.plonk.common.registry.RegistryBlocks;
import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ItemBlockPlacedItems
extends BlockItem {
    private static final String TAG_HELD = "Held";
    private static final String TAG_RENDER_TYPE = "RenderType";

    public ItemBlockPlacedItems(Item.Properties builder) {
        super((Block)RegistryBlocks.placed_items, builder);
    }

    public void setHeldStack(ItemStack stack, ItemStack held, int renderType) {
        CompoundNBT tagCompound = stack.func_196082_o();
        CompoundNBT tagCompoundHeld = tagCompound.func_74775_l(TAG_HELD);
        held.func_77955_b(tagCompoundHeld);
        tagCompound.func_218657_a(TAG_HELD, (INBT)tagCompoundHeld);
        tagCompound.func_74768_a(TAG_RENDER_TYPE, renderType);
        stack.func_77982_d(tagCompound);
    }

    public ItemStack getHeldStack(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b(TAG_HELD)) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((CompoundNBT)tagCompound.func_74775_l(TAG_HELD));
    }

    public int getHeldRenderType(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b(TAG_RENDER_TYPE)) {
            return 0;
        }
        return tagCompound.func_74762_e(TAG_RENDER_TYPE);
    }

    protected boolean tryInsertStack(ItemUseContext context, TilePlacedItems tile) {
        ItemStack heldItem = this.getHeldStack(context.func_195996_i());
        int renderType = this.getHeldRenderType(context.func_195996_i());
        ItemStack remainder = tile.insertStack(heldItem, renderType);
        tile.func_70296_d();
        tile.clean();
        if (remainder != heldItem) {
            this.setHeldStack(context.func_195996_i(), remainder, renderType);
            return true;
        }
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (this.getHeldStack(context.func_195996_i()).func_190926_b()) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        TilePlacedItems tile = null;
        if (world.func_180495_p(pos).func_177230_c() == RegistryBlocks.placed_items) {
            tile = (TilePlacedItems)world.func_175625_s(pos);
        } else {
            BlockPos pos2 = pos.func_177972_a(facing);
            if (world.func_180495_p(pos2).func_177230_c() == RegistryBlocks.placed_items) {
                tile = (TilePlacedItems)world.func_175625_s(pos2);
            }
        }
        PlayerEntity player = context.func_195999_j();
        if (tile != null && this.tryInsertStack(context, tile)) {
            BlockState state = world.func_180495_p(pos);
            SoundType soundtype = state.func_177230_c().getSoundType(state, (IWorldReader)world, pos, (Entity)player);
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    public boolean func_195941_b(BlockItemUseContext context, BlockState newState) {
        if (this.getHeldStack(context.func_195996_i()).func_190926_b()) {
            return false;
        }
        if (!super.func_195941_b(context, newState)) {
            return false;
        }
        TilePlacedItems tile = (TilePlacedItems)context.func_195991_k().func_175625_s(context.func_195995_a());
        if (tile == null) {
            return false;
        }
        return this.tryInsertStack((ItemUseContext)context, tile);
    }
}

