/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.packet;

import com.breakinblocks.plonk.common.packet.PacketBase;
import com.breakinblocks.plonk.common.registry.RegistryItems;
import com.breakinblocks.plonk.common.util.EntityUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketPlaceItem
extends PacketBase {
    private BlockRayTraceResult hit;
    private int renderType;

    public PacketPlaceItem() {
    }

    public PacketPlaceItem(BlockRayTraceResult hit, int renderType) {
        this.hit = hit;
        this.renderType = renderType;
    }

    @Override
    public PacketBase read(PacketBuffer buf) {
        this.hit = buf.func_218669_q();
        this.renderType = buf.readInt();
        return new PacketPlaceItem(this.hit, this.renderType);
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_218668_a(this.hit);
        buf.writeInt(this.renderType);
    }

    @Override
    public Optional<NetworkDirection> getNetworkDirection() {
        return Optional.of(NetworkDirection.PLAY_TO_SERVER);
    }

    @Override
    protected void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = Objects.requireNonNull(ctx.get().getSender());
        ItemStack toPlace = new ItemStack((IItemProvider)RegistryItems.placed_items, 1);
        ItemStack held = player.func_184614_ca();
        RegistryItems.placed_items.setHeldStack(toPlace, held, this.renderType);
        EntityUtils.setHeldItemSilent((PlayerEntity)player, Hand.MAIN_HAND, toPlace);
        if (toPlace.func_196084_a(new ItemUseContext((PlayerEntity)player, Hand.MAIN_HAND, this.hit)) == ActionResultType.SUCCESS) {
            ItemStack newHeld = RegistryItems.placed_items.getHeldStack(toPlace);
            EntityUtils.setHeldItemSilent((PlayerEntity)player, Hand.MAIN_HAND, newHeld);
        } else {
            EntityUtils.setHeldItemSilent((PlayerEntity)player, Hand.MAIN_HAND, held);
        }
    }
}

