/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.client.render.tile;

import com.breakinblocks.plonk.client.util.RenderUtils;
import com.breakinblocks.plonk.common.block.BlockPlacedItems;
import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import com.breakinblocks.plonk.common.util.MatrixUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;

public class TESRPlacedItems
extends TileEntityRenderer<TilePlacedItems> {
    public static final DirectionProperty FACING = BlockPlacedItems.FACING;
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final ItemRenderer itemRenderer = mc.func_175599_af();
    private static final Tessellator tessellator = Tessellator.func_178181_a();
    private static final BufferBuilder bufferbuilder = tessellator.func_178180_c();
    private static final BlockRendererDispatcher blockRendererDispatcher = mc.func_175602_ab();
    private static final double EPS = 0.001;

    public TESRPlacedItems(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public static int getRenderTypeFromStack(ItemStack itemstack) {
        IBakedModel model = itemRenderer.func_184393_a(itemstack, null, null);
        Matrix4f matrixFixed = RenderUtils.getModelTransformMatrix(model, ItemCameraTransforms.TransformType.FIXED);
        Matrix4f matrixGui = RenderUtils.getModelTransformMatrix(model, ItemCameraTransforms.TransformType.GUI);
        Matrix4f difference = MatrixUtils.difference(matrixFixed, matrixGui);
        MatrixUtils.TransformData transform = new MatrixUtils.TransformData(difference);
        double hS = Math.abs((double)(transform.sx + transform.sy + transform.sz) / 3.0);
        double hRotP = (360.0 + transform.pitch) % 90.0;
        hRotP = Math.min(Math.abs(hRotP), Math.abs(hRotP - 90.0));
        double hRotY = (360.0 + transform.yaw) % 90.0;
        hRotY = Math.min(Math.abs(hRotY), Math.abs(hRotY - 90.0));
        double hRotR = (360.0 + transform.roll) % 90.0;
        hRotR = Math.min(Math.abs(hRotR), Math.abs(hRotR - 90.0));
        double hRot = hRotP + hRotY + hRotR;
        double blockRot = 83.80586;
        if (83.80485999999999 <= hRot && hRot <= 83.80686) {
            return 1;
        }
        return 0;
    }

    public void render(TilePlacedItems tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockstate;
        Direction facing = Direction.UP;
        if (tileEntityIn.func_145830_o() && (blockstate = tileEntityIn.func_195044_w()).func_177230_c() instanceof BlockPlacedItems) {
            facing = (Direction)blockstate.func_177229_b((IProperty)FACING);
        }
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        switch (facing) {
            case UP: {
                break;
            }
            case DOWN: {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                break;
            }
            case SOUTH: {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                break;
            }
            case NORTH: {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
                break;
            }
            case EAST: {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-90.0f));
                break;
            }
            case WEST: {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            }
        }
        matrixStackIn.func_227861_a_(0.0, -0.5, 0.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(-tileEntityIn.getTileRotationAngle())));
        ItemStack[] contents = tileEntityIn.getContentsDisplay();
        TilePlacedItems.ItemMeta[] contentsMeta = tileEntityIn.getContentsMeta();
        int num = contents.length;
        if (num > 0) {
            boolean halfSize = num > 1;
            for (int slot = 0; slot < num; ++slot) {
                ItemStack stack = tileEntityIn.func_70301_a(slot);
                if (stack.func_190926_b()) continue;
                matrixStackIn.func_227860_a_();
                switch (num) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (slot == 0) {
                            matrixStackIn.func_227861_a_(-0.25, 0.0, 0.0);
                            break;
                        }
                        matrixStackIn.func_227861_a_(0.25, 0.0, 0.0);
                        break;
                    }
                    default: {
                        boolean left = slot % 2 == 0;
                        boolean top = slot / 2 == 0;
                        matrixStackIn.func_227861_a_(left ? -0.25 : 0.25, 0.0, top ? -0.25 : 0.25);
                    }
                }
                this.renderStack(partialTicks, matrixStackIn, bufferIn, combinedLightIn, stack, contentsMeta[slot], halfSize);
                matrixStackIn.func_227865_b_();
            }
        }
        matrixStackIn.func_227865_b_();
    }

    public void renderStack(float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, ItemStack stack, TilePlacedItems.ItemMeta meta, boolean halfSize) {
        if (stack.func_190926_b()) {
            return;
        }
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(-meta.getRotationAngle())));
        matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 180.0f, true));
        switch (meta.renderType) {
            case 1: {
                matrixStackIn.func_227861_a_(0.0, 0.25, 0.0);
                itemRenderer.func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
                break;
            }
            default: {
                matrixStackIn.func_227861_a_(0.0, 0.0416666679084301, 0.0);
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                if (halfSize) {
                    matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
                }
                itemRenderer.func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
            }
        }
        matrixStackIn.func_227865_b_();
    }
}

