/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.util.bound;

import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class Box {
    public static final Box BLOCK_BOX = new Box(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public final double minX;
    public final double minY;
    public final double minZ;
    public final double maxX;
    public final double maxY;
    public final double maxZ;

    public Box(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public Box(AxisAlignedBB aabb) {
        this(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public AxisAlignedBB toAABB() {
        return new AxisAlignedBB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public VoxelShape toShape() {
        return VoxelShapes.func_197873_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
    }

    public Box copy() {
        return new Box(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public Box rotateX90() {
        return new Box(this.minX, 1.0 - this.maxZ, this.minY, this.maxX, 1.0 - this.minZ, this.maxY);
    }

    public Box rotateX180() {
        return new Box(this.minX, 1.0 - this.maxY, 1.0 - this.maxZ, this.maxX, 1.0 - this.minY, 1.0 - this.minZ);
    }

    public Box rotateX270() {
        return new Box(this.minX, this.minZ, 1.0 - this.maxY, this.maxX, this.maxZ, 1.0 - this.minY);
    }

    public Box rotateY90() {
        return new Box(this.minZ, this.minY, 1.0 - this.maxX, this.maxZ, this.maxY, 1.0 - this.minX);
    }

    public Box rotateY180() {
        return new Box(1.0 - this.maxX, this.minY, 1.0 - this.maxZ, 1.0 - this.minX, this.maxY, 1.0 - this.minZ);
    }

    public Box rotateY270() {
        return new Box(1.0 - this.maxZ, this.minY, this.minX, 1.0 - this.minZ, this.maxY, this.maxX);
    }

    public Box rotateZ90() {
        return new Box(1.0 - this.maxY, this.minX, this.minZ, 1.0 - this.minY, this.maxX, this.maxZ);
    }

    public Box rotateZ180() {
        return new Box(1.0 - this.maxX, 1.0 - this.maxY, this.minZ, 1.0 - this.minX, 1.0 - this.minY, this.maxZ);
    }

    public Box rotateZ270() {
        return new Box(this.minY, 1.0 - this.maxX, this.minZ, this.maxY, 1.0 - this.minX, this.maxZ);
    }

    public Box translate(double dx, double dy, double dz) {
        return new Box(this.minX + dx, this.minY + dy, this.minZ + dz, this.maxX + dx, this.maxY + dy, this.maxZ + dz);
    }

    public Box enclosing(Box o) {
        return new Box(Math.min(this.minX, o.minX), Math.min(this.minY, o.minY), Math.min(this.minZ, o.minZ), Math.max(this.maxX, o.maxX), Math.max(this.maxY, o.maxY), Math.max(this.maxZ, o.maxZ));
    }

    public boolean contains(Vec3d vec) {
        return this.contains(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public boolean contains(double x, double y, double z) {
        return this.minX <= x && x <= this.maxX && this.minY <= y && y <= this.maxY && this.minZ <= z && z <= this.minZ;
    }

    public double distanceSq(Vec3d vec) {
        return this.distanceSq(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public double distanceSq(double x, double y, double z) {
        double dx = Math.max(0.0, Math.max(this.minX - x, x - this.maxX));
        double dy = Math.max(0.0, Math.max(this.minY - y, y - this.maxY));
        double dz = Math.max(0.0, Math.max(this.minZ - z, z - this.maxZ));
        return dx * dx + dy * dy + dz * dz;
    }
}

