/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.client.render.tile;

import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import cpw.mods.fml.common.Loader;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class TESRPlacedItems
extends TileEntitySpecialRenderer {
    private static final boolean ITEM_PHYSIC = Loader.isModLoaded((String)"itemphysic");
    private final RenderBlocks renderBlocks = new RenderBlocks();

    public static int getRenderTypeFromStack(ItemStack itemstack) {
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)itemstack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY);
        if (customRenderer != null) {
            boolean is3D = customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, itemstack, IItemRenderer.ItemRendererHelper.BLOCK_3D);
            Block block = itemstack.func_77973_b() instanceof ItemBlock ? Block.func_149634_a((Item)itemstack.func_77973_b()) : null;
            return is3D || block != null && RenderBlocks.func_147739_a((int)block.func_149645_b()) ? 1 : 0;
        }
        if (itemstack.func_94608_d() == 0 && itemstack.func_77973_b() instanceof ItemBlock && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)itemstack.func_77973_b()).func_149645_b())) {
            return 1;
        }
        return 0;
    }

    public void func_147500_a(TileEntity tileIn, double x, double y, double z, float partialTicks) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        int meta = tileIn.func_145832_p();
        switch (meta) {
            case 0: {
                break;
            }
            case 1: {
                GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case 2: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case 3: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case 4: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case 5: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
            }
        }
        GL11.glTranslated((double)0.0, (double)-0.5, (double)0.0);
        World world = tileIn.func_145831_w();
        TilePlacedItems tile = (TilePlacedItems)tileIn;
        GL11.glRotated((double)(-tile.getTileRotationAngle()), (double)0.0, (double)1.0, (double)0.0);
        ItemStack[] contents = tile.getContentsDisplay();
        TilePlacedItems.ItemMeta[] contentsMeta = tile.getContentsMeta();
        int num = contents.length;
        if (num > 0) {
            boolean halfSize = num > 1;
            for (int slot = 0; slot < num; ++slot) {
                ItemStack stack = tile.func_70301_a(slot);
                if (stack == null) continue;
                GL11.glPushMatrix();
                switch (num) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (slot == 0) {
                            GL11.glTranslated((double)-0.25, (double)0.0, (double)0.0);
                            break;
                        }
                        GL11.glTranslated((double)0.25, (double)0.0, (double)0.0);
                        break;
                    }
                    default: {
                        boolean left = slot % 2 == 0;
                        boolean top = slot / 2 == 0;
                        GL11.glTranslated((double)(left ? -0.25 : 0.25), (double)0.0, (double)(top ? -0.25 : 0.25));
                    }
                }
                this.renderStack(world, stack, contentsMeta[slot], partialTicks, halfSize, true);
                GL11.glPopMatrix();
            }
        }
        GL11.glPopMatrix();
    }

    public void renderStack(World world, ItemStack stack, TilePlacedItems.ItemMeta meta, float partialTicks, boolean halfSize, boolean renderInFrame) {
        GL11.glPushMatrix();
        GL11.glRotated((double)(-meta.getRotationAngle()), (double)0.0, (double)1.0, (double)0.0);
        EntityItem entityItem = new EntityItem(world, 0.0, 0.0, 0.0, stack);
        entityItem.func_92059_d().field_77994_a = 1;
        entityItem.field_70290_d = 0.0f;
        entityItem.field_70177_z = 0.0f;
        entityItem.field_70122_E = true;
        int renderType = TESRPlacedItems.getRenderTypeFromStack(stack);
        if (halfSize || renderType == 1) {
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            if (renderType == 1) {
                GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
            }
        }
        if (renderType == 1) {
            GL11.glTranslated((double)0.0, (double)0.5, (double)0.0);
            GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glScaled((double)4.0, (double)4.0, (double)4.0);
            if (renderInFrame) {
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                if (ITEM_PHYSIC) {
                    GL11.glTranslated((double)0.0, (double)-0.09, (double)0.0);
                }
                GL11.glTranslated((double)0.0, (double)-0.05, (double)0.0);
                GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
            }
        } else {
            GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)-0.25, (double)0.0625);
            if (RenderManager.field_78727_a.field_78733_k.field_74347_j) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                if (renderInFrame) {
                    GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    if (ITEM_PHYSIC) {
                        GL11.glTranslatef((float)0.0f, (float)-0.09f, (float)0.0f);
                    }
                } else if (ITEM_PHYSIC) {
                    GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
            } else if (!renderInFrame) {
                GL11.glRotatef((float)(-(180.0f - RenderManager.field_78727_a.field_78735_i)), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (renderInFrame) {
                GL11.glTranslatef((float)0.0f, (float)0.05f, (float)0.0f);
                GL11.glScaled((double)1.950000048750001, (double)1.950000048750001, (double)1.950000048750001);
            } else {
                GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
            }
        }
        boolean prevRenderInFrame = RenderItem.field_82407_g;
        RenderItem.field_82407_g = renderInFrame;
        if (!ITEM_PHYSIC) {
            GL11.glTranslated((double)0.0, (double)-0.1, (double)0.0);
        }
        RenderManager.field_78727_a.func_147940_a((Entity)entityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        RenderItem.field_82407_g = prevRenderInFrame;
        GL11.glPopMatrix();
    }
}

