/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.block;

import com.breakinblocks.plonk.common.registry.RegistryMaterials;
import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import com.breakinblocks.plonk.common.util.EntityUtils;
import com.breakinblocks.plonk.common.util.ItemUtils;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPlacedItems
extends Block {
    public BlockPlacedItems() {
        super((Material)RegistryMaterials.placed_items);
        this.func_149711_c(0.5f);
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB collider, List collisions, Entity entity) {
        TilePlacedItems tile = (TilePlacedItems)world.func_147438_o(x, y, z);
        tile.getContentsBoxes().addCollisionBoxesToList(this, (x$0, x$1, x$2, x$3, x$4, x$5, x$6) -> super.func_149743_a(x$0, x$1, x$2, x$3, x$4, x$5, x$6), world, x, y, z, collider, collisions, entity);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        TilePlacedItems tile = (TilePlacedItems)Objects.requireNonNull(world.func_147438_o(x, y, z));
        return tile.getContentsBoxes().getSelectedBoundingBoxFromPool();
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TilePlacedItems tile = (TilePlacedItems)world.func_147438_o(x, y, z);
        if (tile != null) {
            for (int slot = 0; slot < tile.func_70302_i_(); ++slot) {
                ItemStack stack = tile.func_70301_a(slot);
                if (stack == null) continue;
                ItemUtils.dropItemWithinBlock(world, x, y, z, stack);
                tile.func_70299_a(slot, null);
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @Nullable
    public Item func_149650_a(int meta, Random rand, int fortune) {
        return null;
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 from, Vec3 to) {
        TilePlacedItems tile = (TilePlacedItems)world.func_147438_o(x, y, z);
        return tile.getContentsBoxes().collisionRayTrace(this, (x$0, x$1, x$2, x$3, x$4, x$5) -> super.func_149731_a(x$0, x$1, x$2, x$3, x$4, x$5), world, x, y, z, from, to);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int meta, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        double reachDistance = playerMP.field_71134_c.getBlockReachDistance();
        float renderPartialTicks = 0.0f;
        Vec3 from = EntityUtils.getEyePosition((EntityLivingBase)player, renderPartialTicks);
        Vec3 look = player.func_70676_i(renderPartialTicks);
        Vec3 to = from.func_72441_c(look.field_72450_a * reachDistance, look.field_72448_b * reachDistance, look.field_72449_c * reachDistance);
        if (world.func_147447_a(from, to, false, false, true) != null) {
            TilePlacedItems tile;
            int index = (tile = (TilePlacedItems)world.func_147438_o(x, y, z)).getContentsBoxes().getSelectedId();
            int slot = index <= 0 ? 0 : index - 1;
            ItemStack stack = tile.func_70301_a(slot);
            if (stack != null) {
                if (player.func_70093_af()) {
                    tile.rotateSlot(slot);
                } else {
                    ItemUtils.dropItemOnEntity((EntityLivingBase)player, stack);
                    tile.func_70299_a(slot, null);
                }
                tile.func_70296_d();
                tile.clean();
            }
            return true;
        }
        return super.func_149727_a(world, x, y, z, player, meta, hitX, hitY, hitZ);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int itemMeta) {
        if (side >= 0 && side < 6) {
            return Facing.field_71588_a[side];
        }
        return super.func_149660_a(world, x, y, z, side, hitX, hitY, hitZ, itemMeta);
    }

    public void func_149719_a(IBlockAccess iba, int x, int y, int z) {
        TilePlacedItems tile = (TilePlacedItems)iba.func_147438_o(x, y, z);
        tile.getContentsBoxes().setBlockBoundsBasedOnState(this, iba, x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        super.func_149689_a(world, x, y, z, entity, stack);
        int meta = world.func_72805_g(x, y, z);
        TilePlacedItems tile = (TilePlacedItems)world.func_147438_o(x, y, z);
        float yaw = entity.field_70177_z % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        int rotation = Math.round(yaw / 90.0f) % 4;
        rotation = meta == 0 ? (rotation + 2) % 4 : (meta == 1 ? 4 - rotation : 0);
        tile.setTileRotation(rotation);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TilePlacedItems();
    }

    @Nullable
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TilePlacedItems tile = (TilePlacedItems)world.func_147438_o(x, y, z);
        int index = tile.getContentsBoxes().getSelectedId();
        int slot = index <= 0 ? 0 : index - 1;
        return tile.func_70301_a(slot);
    }
}

