/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.item;

import com.breakinblocks.plonk.common.registry.RegistryBlocks;
import com.breakinblocks.plonk.common.tile.TilePlacedItems;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Facing;
import net.minecraft.world.World;

public class ItemBlockPlacedItems
extends ItemBlock {
    private static final String TAG_HELD = "Held";
    private static final String TAG_RENDER_TYPE = "RenderType";

    public ItemBlockPlacedItems() {
        super((Block)RegistryBlocks.placed_items);
    }

    public void setHeldStack(ItemStack stack, ItemStack held, int renderType) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (held == null) {
            tagCompound.func_82580_o(TAG_HELD);
        } else {
            NBTTagCompound tagCompoundHeld = tagCompound.func_74775_l(TAG_HELD);
            held.func_77955_b(tagCompoundHeld);
            tagCompound.func_74782_a(TAG_HELD, (NBTBase)tagCompoundHeld);
        }
        tagCompound.func_74768_a(TAG_RENDER_TYPE, renderType);
        stack.func_77982_d(tagCompound);
    }

    public ItemStack getHeldStack(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b(TAG_HELD)) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l(TAG_HELD));
    }

    public int getHeldRenderType(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e(TAG_RENDER_TYPE);
    }

    protected boolean tryInsertStack(ItemStack placerStack, TilePlacedItems tile, EntityPlayer player) {
        ItemStack heldItem = this.getHeldStack(placerStack);
        int renderType = this.getHeldRenderType(placerStack);
        ItemStack remainder = tile.insertStack(heldItem, renderType);
        tile.func_70296_d();
        tile.clean();
        if (remainder != heldItem) {
            this.setHeldStack(placerStack, remainder, renderType);
            return true;
        }
        return false;
    }

    public boolean func_77648_a(ItemStack placerStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (placerStack == null || this.getHeldStack(placerStack) == null || this.getHeldStack((ItemStack)placerStack).field_77994_a <= 0) {
            return false;
        }
        TilePlacedItems tile = null;
        if (world.func_147439_a(x, y, z) == RegistryBlocks.placed_items) {
            tile = (TilePlacedItems)world.func_147438_o(x, y, z);
        } else {
            int x2 = x + Facing.field_71586_b[side];
            int y2 = y + Facing.field_71587_c[side];
            int z2 = z + Facing.field_71585_d[side];
            if (world.func_147439_a(x2, y2, z2) == RegistryBlocks.placed_items) {
                tile = (TilePlacedItems)world.func_147438_o(x2, y2, z2);
            }
        }
        if (tile != null && this.tryInsertStack(placerStack, tile, player)) {
            world.func_72908_a((double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 0.5, (double)tile.field_145849_e + 0.5, this.field_150939_a.field_149762_H.func_150496_b(), (this.field_150939_a.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.field_150939_a.field_149762_H.func_150494_d() * 0.8f);
            return true;
        }
        return super.func_77648_a(placerStack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public boolean placeBlockAt(ItemStack placerStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (this.getHeldStack(placerStack) == null || this.getHeldStack((ItemStack)placerStack).field_77994_a <= 0) {
            return false;
        }
        if (!super.placeBlockAt(placerStack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            return false;
        }
        TilePlacedItems tile = (TilePlacedItems)world.func_147438_o(x, y, z);
        if (tile == null) {
            return false;
        }
        if (this.tryInsertStack(placerStack, tile, player)) {
            world.func_72908_a((double)((float)tile.field_145851_c + 0.5f), (double)((float)tile.field_145848_d + 0.5f), (double)((float)tile.field_145849_e + 0.5f), this.field_150939_a.field_149762_H.func_150496_b(), (this.field_150939_a.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.field_150939_a.field_149762_H.func_150494_d() * 0.8f);
            return true;
        }
        return false;
    }
}

