/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.packet;

import com.breakinblocks.plonk.common.packet.PacketBase;
import com.breakinblocks.plonk.common.registry.RegistryItems;
import com.breakinblocks.plonk.common.util.EntityUtils;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class PacketPlaceItem
extends PacketBase<PacketPlaceItem> {
    private int x;
    private int y;
    private int z;
    private int side;
    private float hitX;
    private float hitY;
    private float hitZ;
    private int renderType;

    public PacketPlaceItem() {
    }

    public PacketPlaceItem(int x, int y, int z, int side, float hitX, float hitY, float hitZ, int renderType) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.side = side;
        this.hitX = hitX;
        this.hitY = hitY;
        this.hitZ = hitZ;
        this.renderType = renderType;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.side = buf.readInt();
        this.hitX = buf.readFloat();
        this.hitY = buf.readFloat();
        this.hitZ = buf.readFloat();
        this.renderType = buf.readInt();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.side);
        buf.writeFloat(this.hitX);
        buf.writeFloat(this.hitY);
        buf.writeFloat(this.hitZ);
        buf.writeInt(this.renderType);
    }

    @Override
    protected void handle(MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            throw new RuntimeException("PacketPlaceItem should be server-bound only.");
        }
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        World world = player.func_130014_f_();
        ItemStack toPlace = new ItemStack((Item)RegistryItems.placed_items, 1);
        ItemStack held = player.func_70694_bm();
        RegistryItems.placed_items.setHeldStack(toPlace, held, this.renderType);
        EntityUtils.setHeldItemSilent((EntityPlayer)player, toPlace);
        if (toPlace.func_77943_a((EntityPlayer)player, world, this.x, this.y, this.z, this.side, this.hitX, this.hitY, this.hitZ)) {
            ItemStack newHeld = RegistryItems.placed_items.getHeldStack(toPlace);
            EntityUtils.setHeldItemSilent((EntityPlayer)player, newHeld);
        } else {
            EntityUtils.setHeldItemSilent((EntityPlayer)player, held);
        }
    }
}

