/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.tile;

import com.breakinblocks.plonk.Plonk;
import com.breakinblocks.plonk.common.config.PlonkConfig;
import com.breakinblocks.plonk.common.util.ItemUtils;
import com.breakinblocks.plonk.common.util.bound.Box;
import com.breakinblocks.plonk.common.util.bound.BoxCollection;
import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TilePlacedItems
extends TileEntity
implements ISidedInventory {
    public static final float HEIGHT_PLATE = 0.03125f;
    public static final float HEIGHT_ITEM = 0.09375f;
    public static final float HEIGHT_BLOCK = 0.5f;
    public static final float BLOCK_PADDING_PERCENTAGE = 0.0f;
    public static final float BLOCK_PADDING_AMOUNT = 0.0f;
    public static final Box BOX_BLOCK = new Box(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    public static final Box BOX_ITEM_ONE = new Box(0.0, 0.0, 0.0, 1.0, 0.09375, 1.0);
    public static final Box BOX_ITEM_MANY = new Box(0.25, 0.0, 0.25, 0.75, 0.09375, 0.75);
    public static final int NBT_VERSION = 1;
    public static final String TAG_VERSION = "Version";
    public static final String TAG_TILE_ROTATION = "TileRotation";
    public static final int TILE_ROTATION_COUNT = 4;
    public static final String TAG_ITEMS = "Items";
    public static final String TAG_SLOT = "Slot";
    public static final String TAG_RENDER_TYPE = "RenderType";
    public static final int RENDER_TYPE_BLOCK = 1;
    public static final int RENDER_TYPE_ITEM = 0;
    public static final String TAG_ITEM_ROTATION = "ItemRotation";
    public static final int ITEM_ROTATION_COUNT = 16;
    private int tileRotation = 0;
    private ItemStack[] contents = new ItemStack[this.func_70302_i_()];
    private ItemMeta[] contentsMeta = new ItemMeta[this.func_70302_i_()];
    private ItemStack[] contentsDisplay = new ItemStack[0];
    private BoxCollection contentsBoxes = new BoxCollection.Builder().addBox(0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0).build();
    private boolean needsCleaning = true;

    public TilePlacedItems() {
        Arrays.fill(this.contentsMeta, ItemMeta.DEFAULT);
    }

    public boolean clean() {
        int first_empty = -1;
        int last_not_empty = -1;
        int count = 0;
        for (int i = 0; i < this.contents.length; ++i) {
            if (this.contents[i] == null) {
                if (first_empty != -1) continue;
                first_empty = i;
                continue;
            }
            last_not_empty = i;
            ++count;
        }
        if (last_not_empty == -1) {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (this.contentsDisplay.length == count) {
            if (first_empty == -1) {
                return false;
            }
            if (first_empty > last_not_empty) {
                return false;
            }
        }
        this.updateContents();
        this.updateContentsDisplay();
        return true;
    }

    private boolean updateContents() {
        boolean changed = false;
        block0: for (int i = 0; i < this.contents.length - 1; ++i) {
            if (this.contents[i] != null) continue;
            for (int j = i + 1; j < this.contents.length; ++j) {
                if (this.contents[j] == null) continue;
                this.contents[i] = this.contents[j];
                this.contentsMeta[i] = this.contentsMeta[j];
                this.contentsMeta[j] = ItemMeta.DEFAULT;
                this.contents[j] = null;
                changed = true;
                continue block0;
            }
        }
        return changed;
    }

    private int updateContentsDisplay() {
        int count = 0;
        for (int i = 0; i < this.contents.length; ++i) {
            if (this.contents[i] == null) continue;
            count = i + 1;
        }
        this.contentsDisplay = Arrays.copyOf(this.contents, count);
        this.updateContentsBoxes(count);
        return count;
    }

    private Box getBox(int count, int renderType) {
        switch (renderType) {
            case 1: {
                return BOX_BLOCK;
            }
        }
        return count == 1 ? BOX_ITEM_ONE : BOX_ITEM_MANY;
    }

    private void updateContentsBoxes(int count) {
        BoxCollection.Builder builder = new BoxCollection.Builder(false, true);
        switch (count) {
            case 1: {
                builder.addBox(1, this.getBox(count, this.contentsMeta[0].renderType));
                break;
            }
            case 2: {
                builder.addBox(1, this.getBox(count, this.contentsMeta[0].renderType).translate(-0.25, 0.0, 0.0));
                builder.addBox(2, this.getBox(count, this.contentsMeta[1].renderType).translate(0.25, 0.0, 0.0));
                break;
            }
            case 4: {
                builder.addBox(4, this.getBox(count, this.contentsMeta[3].renderType).translate(0.25, 0.0, 0.25));
            }
            case 3: {
                builder.addBox(1, this.getBox(count, this.contentsMeta[0].renderType).translate(-0.25, 0.0, -0.25));
                builder.addBox(2, this.getBox(count, this.contentsMeta[1].renderType).translate(0.25, 0.0, -0.25));
                builder.addBox(3, this.getBox(count, this.contentsMeta[2].renderType).translate(-0.25, 0.0, 0.25));
                break;
            }
            default: {
                builder.addBox(0, 0.0, 0.0, 0.0, 1.0, 0.03125, 1.0);
            }
        }
        switch (this.tileRotation % 4) {
            case 0: {
                break;
            }
            case 1: {
                builder.apply(Box::rotateY270);
                break;
            }
            case 2: {
                builder.apply(Box::rotateY180);
                break;
            }
            case 3: {
                builder.apply(Box::rotateY90);
            }
        }
        int meta = this.func_145830_o() ? this.func_145832_p() : 0;
        switch (meta) {
            case 0: {
                break;
            }
            case 1: {
                builder.apply(Box::rotateZ180);
                break;
            }
            case 2: {
                builder.apply(Box::rotateX90);
                break;
            }
            case 3: {
                builder.apply(Box::rotateX90).apply(Box::rotateY180);
                break;
            }
            case 4: {
                builder.apply(Box::rotateX90).apply(Box::rotateY90);
                break;
            }
            case 5: {
                builder.apply(Box::rotateX90).apply(Box::rotateY270);
            }
        }
        this.contentsBoxes = builder.build();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTUpgrader.upgrade(tag);
        NBTTagList tagItems = tag.func_150295_c(TAG_ITEMS, 10);
        this.contents = new ItemStack[this.func_70302_i_()];
        this.contentsMeta = new ItemMeta[this.func_70302_i_()];
        Arrays.fill(this.contentsMeta, ItemMeta.DEFAULT);
        for (int i = 0; i < tagItems.func_74745_c(); ++i) {
            NBTTagCompound tagItem = tagItems.func_150305_b(i);
            int slot = tagItem.func_74771_c(TAG_SLOT) & 0xFF;
            int renderType = tagItem.func_74762_e(TAG_RENDER_TYPE);
            int itemRotation = tagItem.func_74762_e(TAG_ITEM_ROTATION);
            if (slot < 0 || slot >= this.contents.length) continue;
            this.contents[slot] = ItemStack.func_77949_a((NBTTagCompound)tagItem);
            this.contentsMeta[slot] = new ItemMeta(renderType, itemRotation);
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a(TAG_VERSION, 1);
        tag.func_74768_a(TAG_TILE_ROTATION, this.tileRotation);
        NBTTagList tagItems = new NBTTagList();
        for (int slot = 0; slot < this.contents.length; ++slot) {
            if (this.contents[slot] == null) continue;
            NBTTagCompound tagItem = new NBTTagCompound();
            tagItem.func_74774_a(TAG_SLOT, (byte)slot);
            tagItem.func_74768_a(TAG_RENDER_TYPE, this.contentsMeta[slot].renderType);
            tagItem.func_74768_a(TAG_ITEM_ROTATION, this.contentsMeta[slot].rotation);
            this.contents[slot].func_77955_b(tagItem);
            tagItems.func_74742_a((NBTBase)tagItem);
        }
        tag.func_74782_a(TAG_ITEMS, (NBTBase)tagItems);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.needsCleaning) {
            if (this.clean()) {
                this.func_70296_d();
            }
            this.needsCleaning = false;
        }
    }

    public void func_70296_d() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        super.func_70296_d();
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.updateContentsDisplay();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    public int func_70302_i_() {
        return 4;
    }

    @Nullable
    public ItemStack func_70301_a(int slot) {
        return this.contents[slot];
    }

    @Nullable
    public ItemStack func_70298_a(int slot, int maxAmount) {
        ItemStack current = this.contents[slot];
        if (maxAmount > 0 && current != null && current.field_77994_a > 0) {
            int amount = Math.min(current.field_77994_a, maxAmount);
            ItemStack extractedStack = current.func_77946_l();
            extractedStack.field_77994_a = amount;
            current.field_77994_a -= amount;
            if (current.field_77994_a <= 0) {
                this.contents[slot] = null;
            }
            this.needsCleaning = true;
            return extractedStack;
        }
        return null;
    }

    @Nullable
    public ItemStack func_70304_b(int slot) {
        return this.contents[slot];
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (stack == null || stack.field_77994_a <= 0) {
            this.contents[slot] = null;
        } else {
            if (stack.field_77994_a > this.func_70297_j_()) {
                stack.field_77994_a = this.func_70297_j_();
            }
            this.contents[slot] = stack;
        }
        this.needsCleaning = true;
    }

    public String func_145825_b() {
        return "container.placed_items";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return PlonkConfig.getInventoryStackLimit();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return true;
    }

    public int getTileRotation() {
        return this.tileRotation;
    }

    public void setTileRotation(int tileRotation) {
        this.tileRotation = tileRotation % 4;
    }

    public double getTileRotationAngle() {
        return 360.0 * (double)this.getTileRotation() / 4.0;
    }

    public void rotateTile() {
        this.tileRotation = (this.tileRotation + 1) % 4;
        this.updateContentsDisplay();
    }

    public void rotateSlot(int slot) {
        if (0 <= slot && slot < this.contentsMeta.length) {
            this.contentsMeta[slot] = this.contentsMeta[slot].rotate();
        }
    }

    public ItemStack[] getContentsDisplay() {
        return this.contentsDisplay;
    }

    public ItemMeta[] getContentsMeta() {
        return this.contentsMeta;
    }

    public BoxCollection getContentsBoxes() {
        return this.contentsBoxes;
    }

    public ItemStack insertStack(ItemStack stack, int renderType) {
        ItemUtils.InsertStackResult result = ItemUtils.insertStackAdv((IInventory)this, stack);
        if (result.remainder != stack) {
            for (int slot : result.slots) {
                this.contentsMeta[slot] = this.contentsMeta[slot].withRenderType(renderType);
            }
        }
        return result.remainder;
    }

    private static class NBTUpgrader {
        public static final ImmutableMap<Integer, Upgrade> UPGRADES = ImmutableMap.builder().put((Object)0, NBTUpgrader::upgradeFrom0To1).build();

        private NBTUpgrader() {
        }

        public static void upgrade(NBTTagCompound tag) {
            int tileVersion = tag.func_74762_e(TilePlacedItems.TAG_VERSION);
            while (tileVersion < 1 && UPGRADES.containsKey((Object)tileVersion)) {
                ((Upgrade)UPGRADES.get((Object)tileVersion)).apply(tag);
                tileVersion = tag.func_74762_e(TilePlacedItems.TAG_VERSION);
            }
            if (tileVersion < 1) {
                throw new RuntimeException("Failed to upgrade an existing tile!");
            }
            if (tileVersion > 1) {
                Plonk.LOG.warn("Placed Items tile version " + tileVersion + " > " + 1 + " (current). Potential loss of data.");
            }
        }

        public static void upgradeFrom0To1(NBTTagCompound tag) {
            String TAG_IS_BLOCK = "IsBlock";
            String TAG_VERSION = TilePlacedItems.TAG_VERSION;
            String TAG_TILE_ROTATION = TilePlacedItems.TAG_TILE_ROTATION;
            String TAG_ITEMS = TilePlacedItems.TAG_ITEMS;
            String TAG_RENDER_TYPE = TilePlacedItems.TAG_RENDER_TYPE;
            String TAG_ITEM_ROTATION = TilePlacedItems.TAG_ITEM_ROTATION;
            tag.func_74768_a(TilePlacedItems.TAG_VERSION, 1);
            tag.func_74768_a(TilePlacedItems.TAG_TILE_ROTATION, 0);
            NBTTagList tagItems = tag.func_150295_c(TilePlacedItems.TAG_ITEMS, 10);
            for (int i = 0; i < tagItems.func_74745_c(); ++i) {
                NBTTagCompound tagItem = tagItems.func_150305_b(i);
                if (tagItem.func_74764_b("IsBlock")) {
                    boolean isBlock = tagItem.func_74767_n("IsBlock");
                    tagItem.func_74768_a(TilePlacedItems.TAG_RENDER_TYPE, isBlock ? 1 : 0);
                }
                tagItem.func_74768_a(TilePlacedItems.TAG_ITEM_ROTATION, 0);
            }
        }

        private static interface Upgrade {
            public void apply(NBTTagCompound var1);
        }
    }

    public static final class ItemMeta {
        public static final ItemMeta DEFAULT = new ItemMeta(0, 0);
        public final int renderType;
        public final int rotation;

        private ItemMeta(int renderType, int rotation) {
            this.renderType = renderType;
            this.rotation = rotation;
        }

        public ItemMeta withRenderType(int renderType) {
            return new ItemMeta(renderType, this.rotation);
        }

        public ItemMeta withRotation(int rotation) {
            return new ItemMeta(this.renderType, rotation);
        }

        public ItemMeta rotate() {
            return this.withRotation((this.rotation + 1) % 16);
        }

        public double getRotationAngle() {
            return 360.0 * (double)this.rotation / 16.0;
        }
    }
}

