/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.plonk.common.util;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemUtils {
    private static final ItemStack REFERENCE = new ItemStack(Blocks.field_150348_b);

    public static EntityItem dropItemWithinBlock(World world, int x, int y, int z, ItemStack stack) {
        if (stack == null || stack.field_77994_a <= 0) {
            return null;
        }
        Random rand = world.field_73012_v;
        float offsetX = rand.nextFloat() * 0.8f + 0.1f;
        float offsetY = rand.nextFloat() * 0.8f + 0.1f;
        float offsetZ = rand.nextFloat() * 0.8f + 0.1f;
        EntityItem entityItem = new EntityItem(world, (double)((float)x + offsetX), (double)((float)y + offsetY), (double)((float)z + offsetZ), stack.func_77946_l());
        float maxVariation = 0.05f;
        entityItem.field_70159_w = (float)rand.nextGaussian() * maxVariation;
        entityItem.field_70181_x = (float)rand.nextGaussian() * maxVariation + 0.2f;
        entityItem.field_70179_y = (float)rand.nextGaussian() * maxVariation;
        if (stack.func_77942_o()) {
            entityItem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
        }
        world.func_72838_d((Entity)entityItem);
        return entityItem;
    }

    public static EntityItem dropItemOnEntity(EntityLivingBase entity, ItemStack stack) {
        if (stack == null || stack.field_77994_a <= 0) {
            return null;
        }
        double x = entity.field_70165_t;
        double y = entity.field_70163_u;
        double z = entity.field_70161_v;
        EntityItem entityItem = new EntityItem(entity.field_70170_p, x, y, z, stack.func_77946_l());
        if (stack.func_77942_o()) {
            entityItem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
        }
        entity.field_70170_p.func_72838_d((Entity)entityItem);
        return entityItem;
    }

    public static boolean areStacksEqualIgnoringSize(ItemStack a, ItemStack b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (!a.func_77969_a(b)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    public static ItemStack insertStack(IInventory inv, ItemStack stack) {
        return ItemUtils.insertStackAdv((IInventory)inv, (ItemStack)stack).remainder;
    }

    public static InsertStackResult insertStackAdv(IInventory inv, ItemStack stack) {
        if (stack == null) {
            return null;
        }
        int stackSizeLimit = Math.min(stack.func_77976_d(), inv.func_70297_j_());
        int size = inv.func_70302_i_();
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack current = inv.func_70301_a(slot);
            if (current == null) {
                current = stack.func_77946_l();
                current.field_77994_a = 0;
            }
            if (current.field_77994_a >= stackSizeLimit || !ItemUtils.areStacksEqualIgnoringSize(current, stack)) continue;
            int total = current.field_77994_a + stack.field_77994_a;
            current.field_77994_a = Math.min(total, stackSizeLimit);
            inv.func_70299_a(slot, current);
            slots.add(slot);
            int remaining = total - current.field_77994_a;
            if (remaining <= 0) {
                stack = null;
                break;
            }
            stack = stack.func_77946_l();
            stack.field_77994_a = remaining;
        }
        int[] slotsArray = new int[slots.size()];
        for (int i = 0; i < slots.size(); ++i) {
            slotsArray[i] = (Integer)slots.get(i);
        }
        return new InsertStackResult(stack, slotsArray);
    }

    public static int getMaxStackSize() {
        return REFERENCE.func_77976_d();
    }

    public static class InsertStackResult {
        public final ItemStack remainder;
        public final int[] slots;

        public InsertStackResult(ItemStack remainder, int[] slots) {
            this.remainder = remainder;
            this.slots = slots;
        }
    }
}

