/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import net.optifine.Config;

public class MatchProfession {
    private bju profession;
    private int[] levels;

    public MatchProfession(bju profession) {
        this(profession, null);
    }

    public MatchProfession(bju profession, int level) {
        this(profession, new int[]{level});
    }

    public MatchProfession(bju profession, int[] levels) {
        this.profession = profession;
        this.levels = levels;
    }

    public boolean matches(bju prof, int lev) {
        if (this.profession != prof) {
            return false;
        }
        return this.levels == null || Config.equalsOne(lev, this.levels);
    }

    private boolean hasLevel(int lev) {
        if (this.levels == null) {
            return false;
        }
        return Config.equalsOne(lev, this.levels);
    }

    public boolean addLevel(int lev) {
        if (this.levels == null) {
            this.levels = new int[]{lev};
            return true;
        }
        if (this.hasLevel(lev)) {
            return false;
        }
        this.levels = Config.addIntToArray(this.levels, lev);
        return true;
    }

    public bju getProfession() {
        return this.profession;
    }

    public int[] getLevels() {
        return this.levels;
    }

    public static boolean matchesOne(bju prof, int level, MatchProfession[] mps) {
        if (mps == null) {
            return false;
        }
        for (int i2 = 0; i2 < mps.length; ++i2) {
            MatchProfession mp = mps[i2];
            if (!mp.matches(prof, level)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.levels == null) {
            return "" + this.profession;
        }
        return "" + this.profession + ":" + Config.arrayToString(this.levels);
    }
}

