/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.optifine.Config;

public class EntityUtils {
    private static final Map<atk, Integer> mapIdByType = new HashMap<atk, Integer>();
    private static final Map<String, Integer> mapIdByLocation = new HashMap<String, Integer>();
    private static final Map<String, Integer> mapIdByName = new HashMap<String, Integer>();

    public static int getEntityIdByClass(atg entity) {
        if (entity == null) {
            return -1;
        }
        return EntityUtils.getEntityIdByType(entity.Y());
    }

    public static int getEntityIdByType(atk type) {
        Integer id = mapIdByType.get(type);
        if (id == null) {
            return -1;
        }
        return id;
    }

    public static int getEntityIdByLocation(String locStr) {
        Integer id = mapIdByLocation.get(locStr);
        if (id == null) {
            return -1;
        }
        return id;
    }

    public static int getEntityIdByName(String name) {
        Integer id = mapIdByName.get(name = name.toLowerCase(Locale.ROOT));
        if (id == null) {
            return -1;
        }
        return id;
    }

    static {
        for (atk type : gw.Y) {
            int id = gw.Y.a((Object)type);
            ww loc = gw.Y.b((Object)type);
            String locStr = loc.toString();
            String name = loc.a();
            if (mapIdByType.containsKey(type)) {
                Config.warn("Duplicate entity type: " + type + ", id1: " + mapIdByType.get(type) + ", id2: " + id);
            }
            if (mapIdByLocation.containsKey(locStr)) {
                Config.warn("Duplicate entity location: " + locStr + ", id1: " + mapIdByLocation.get(locStr) + ", id2: " + id);
            }
            if (mapIdByName.containsKey(locStr)) {
                Config.warn("Duplicate entity name: " + name + ", id1: " + mapIdByName.get(name) + ", id2: " + id);
            }
            mapIdByType.put(type, id);
            mapIdByLocation.put(locStr, id);
            mapIdByName.put(name, id);
        }
    }
}

