/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.optifine.Config;
import net.optifine.DynamicLight;
import net.optifine.DynamicLightsMap;
import net.optifine.config.ConnectedParser;
import net.optifine.config.EntityTypeNameLocator;
import net.optifine.config.IObjectLocator;
import net.optifine.config.ItemLocator;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.util.PropertiesOrdered;

public class DynamicLights {
    private static DynamicLightsMap mapDynamicLights = new DynamicLightsMap();
    private static Map<String, Integer> mapEntityLightLevels = new HashMap<String, Integer>();
    private static Map<bql, Integer> mapItemLightLevels = new HashMap<bql, Integer>();
    private static long timeUpdateMs = 0L;
    private static final double MAX_DIST = 7.5;
    private static final double MAX_DIST_SQ = 56.25;
    private static final int LIGHT_LEVEL_MAX = 15;
    private static final int LIGHT_LEVEL_FIRE = 15;
    private static final int LIGHT_LEVEL_BLAZE = 10;
    private static final int LIGHT_LEVEL_MAGMA_CUBE = 8;
    private static final int LIGHT_LEVEL_MAGMA_CUBE_CORE = 13;
    private static final int LIGHT_LEVEL_GLOWSTONE_DUST = 8;
    private static final int LIGHT_LEVEL_PRISMARINE_CRYSTALS = 8;
    private static final int LIGHT_LEVEL_GLOW_SQUID = 11;
    private static final int LIGHT_LEVEL_GLOW_INK_SAC = 8;
    private static final int LIGHT_LEVEL_GLOW_LICHEN = 6;
    private static final int LIGHT_LEVEL_GLOW_BERRIES = 12;
    private static final int LIGHT_LEVEL_GLOW_ITEM_FRAME = 8;
    private static final wf<bqp> PARAMETER_ITEM_STACK = (wf)Reflector.EntityItem_ITEM.getValue();
    private static boolean initialized;

    public static void entityAdded(atf entityIn, enf renderGlobal) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entityRemoved(atf entityIn, enf renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLight dynamicLight = mapDynamicLights.remove(entityIn.Z());
            if (dynamicLight != null) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(enf renderGlobal) {
        long timeNowMs = System.currentTimeMillis();
        if (timeNowMs < timeUpdateMs + 50L) {
            return;
        }
        timeUpdateMs = timeNowMs;
        if (!initialized) {
            DynamicLights.initialize();
        }
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLights.updateMapDynamicLights(renderGlobal);
            if (mapDynamicLights.size() <= 0) {
                return;
            }
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            for (int i2 = 0; i2 < dynamicLights.size(); ++i2) {
                DynamicLight dynamicLight = dynamicLights.get(i2);
                dynamicLight.update(renderGlobal);
            }
        }
    }

    private static void initialize() {
        initialized = true;
        mapEntityLightLevels.clear();
        mapItemLightLevels.clear();
        String[] modIds = ReflectorForge.getForgeModIds();
        for (int i2 = 0; i2 < modIds.length; ++i2) {
            String modId = modIds[i2];
            try {
                ww loc = new ww(modId, "optifine/dynamic_lights.properties");
                InputStream in = Config.getResourceStream(loc);
                DynamicLights.loadModConfiguration(in, loc.toString(), modId);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (mapEntityLightLevels.size() > 0) {
            Config.dbg("DynamicLights entities: " + mapEntityLightLevels.size());
        }
        if (mapItemLightLevels.size() > 0) {
            Config.dbg("DynamicLights items: " + mapItemLightLevels.size());
        }
    }

    private static void loadModConfiguration(InputStream in, String path, String modId) {
        if (in == null) {
            return;
        }
        try {
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            Config.dbg("DynamicLights: Parsing " + path);
            ConnectedParser cp = new ConnectedParser("DynamicLights");
            DynamicLights.loadModLightLevels(props.getProperty("entities"), mapEntityLightLevels, new EntityTypeNameLocator(), cp, path, modId);
            DynamicLights.loadModLightLevels(props.getProperty("items"), mapItemLightLevels, new ItemLocator(), cp, path, modId);
        }
        catch (IOException e2) {
            Config.warn("DynamicLights: Error reading " + path);
        }
    }

    private static <T> void loadModLightLevels(String prop, Map<T, Integer> mapLightLevels, IObjectLocator<T> ol, ConnectedParser cp, String path, String modId) {
        if (prop == null) {
            return;
        }
        String[] parts = Config.tokenize(prop, " ");
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            String[] tokens = Config.tokenize(part, ":");
            if (tokens.length != 2) {
                cp.warn("Invalid entry: " + part + ", in:" + path);
                continue;
            }
            String name = tokens[0];
            String light = tokens[1];
            String nameFull = modId + ":" + name;
            ww loc = new ww(nameFull);
            T obj = ol.getObject(loc);
            if (obj == null) {
                cp.warn("Object not found: " + nameFull);
                continue;
            }
            int lightLevel = cp.parseInt(light, -1);
            if (lightLevel < 0 || lightLevel > 15) {
                cp.warn("Invalid light level: " + part);
                continue;
            }
            mapLightLevels.put(obj, new Integer(lightLevel));
        }
    }

    private static void updateMapDynamicLights(enf renderGlobal) {
        ejh world = renderGlobal.getWorld();
        if (world == null) {
            return;
        }
        Iterable entities = world.b();
        for (atf entity : entities) {
            DynamicLight dynamicLight;
            int key;
            int lightLevel = DynamicLights.getLightLevel(entity);
            if (lightLevel > 0) {
                key = entity.Z();
                dynamicLight = mapDynamicLights.get(key);
                if (dynamicLight != null) continue;
                dynamicLight = new DynamicLight(entity);
                mapDynamicLights.put(key, dynamicLight);
                continue;
            }
            key = entity.Z();
            dynamicLight = mapDynamicLights.remove(key);
            if (dynamicLight == null) continue;
            dynamicLight.updateLitChunks(renderGlobal);
        }
    }

    public static int getCombinedLight(gg pos, int combinedLight) {
        double lightPos = DynamicLights.getLightLevel(pos);
        combinedLight = DynamicLights.getCombinedLight(lightPos, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(atf entity, int combinedLight) {
        double lightPos = DynamicLights.getLightLevel(entity.cR());
        if (entity == Config.getMinecraft().t) {
            double lightOwn = DynamicLights.getLightLevel(entity);
            lightPos = Math.max(lightPos, lightOwn);
        }
        combinedLight = DynamicLights.getCombinedLight(lightPos, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(double lightPlayer, int combinedLight) {
        int lightBlockFF;
        int lightPlayerFF;
        if (lightPlayer > 0.0 && (lightPlayerFF = (int)(lightPlayer * 16.0)) > (lightBlockFF = combinedLight & 0xFF)) {
            combinedLight &= 0xFFFFFF00;
            combinedLight |= lightPlayerFF;
        }
        return combinedLight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getLightLevel(gg pos) {
        double lightLevelMax = 0.0;
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            int dynamicLightsSize = dynamicLights.size();
            for (int i2 = 0; i2 < dynamicLightsSize; ++i2) {
                double dist;
                double light;
                double lightLevel;
                double dz;
                double dy;
                DynamicLight dynamicLight = dynamicLights.get(i2);
                int dynamicLightLevel = dynamicLight.getLastLightLevel();
                if (dynamicLightLevel <= 0) continue;
                double px = dynamicLight.getLastPosX();
                double py = dynamicLight.getLastPosY();
                double pz = dynamicLight.getLastPosZ();
                double dx = (double)pos.u() - px;
                double distSq = dx * dx + (dy = (double)pos.v() - py) * dy + (dz = (double)pos.w() - pz) * dz;
                if (distSq > 56.25 || !((lightLevel = (light = 1.0 - (dist = Math.sqrt(distSq)) / 7.5) * (double)dynamicLightLevel) > lightLevelMax)) continue;
                lightLevelMax = lightLevel;
            }
        }
        double lightPlayer = Config.limit(lightLevelMax, 0.0, 15.0);
        return lightPlayer;
    }

    public static int getLightLevel(bqp itemStack) {
        Integer level;
        bot itemBlock;
        bzo block;
        if (itemStack == null) {
            return 0;
        }
        bql item = itemStack.c();
        if (item instanceof bot && (block = (itemBlock = (bot)item).e()) != null) {
            if (block == bzp.gC) {
                return 0;
            }
            if (block == bzp.dY) {
                return 6;
            }
            if (block == bzp.pB) {
                return 12;
            }
            return block.n().f();
        }
        if (item == bqr.nY) {
            return bzp.B.n().f();
        }
        if (item == bqr.pB || item == bqr.pJ) {
            return 10;
        }
        if (item == bqr.ou) {
            return 8;
        }
        if (item == bqr.rE) {
            return 8;
        }
        if (item == bqr.pK) {
            return 8;
        }
        if (item == bqr.rx) {
            return bzp.eF.n().f() / 2;
        }
        if (item == bqr.oC) {
            return 8;
        }
        if (item == bqr.rj) {
            return 8;
        }
        if (!mapItemLightLevels.isEmpty() && (level = mapItemLightLevels.get(item)) != null) {
            return level;
        }
        return 0;
    }

    public static int getLightLevel(atf entity) {
        bhj entityCreeper;
        String typeName;
        Integer level;
        bkd player;
        if (entity == Config.getMinecraft().aa() && !Config.isDynamicHandLight()) {
            return 0;
        }
        if (entity instanceof bkd && (player = (bkd)entity).A_()) {
            return 0;
        }
        if (entity.bz()) {
            return 15;
        }
        if (!mapEntityLightLevels.isEmpty() && (level = mapEntityLightLevels.get(typeName = EntityTypeNameLocator.getEntityTypeName(entity))) != null) {
            return level;
        }
        if (entity instanceof bki) {
            return 15;
        }
        if (entity instanceof bhd) {
            return 15;
        }
        if (entity instanceof bhh) {
            bhh entityBlaze = (bhh)entity;
            if (entityBlaze.bz()) {
                return 15;
            }
            return 10;
        }
        if (entity instanceof bhw) {
            bhw emc = (bhw)entity;
            if ((double)emc.e > 0.6) {
                return 13;
            }
            return 8;
        }
        if (entity instanceof bhj && (double)(entityCreeper = (bhj)entity).z(0.0f) > 0.001) {
            return 15;
        }
        if (entity instanceof atn) {
            return 11;
        }
        if (entity instanceof bgu) {
            return 8;
        }
        if (entity instanceof att) {
            player = (att)entity;
            bqp stackMain = player.el();
            int levelMain = DynamicLights.getLightLevel(stackMain);
            bqp stackOff = player.em();
            int levelOff = DynamicLights.getLightLevel(stackOff);
            bqp stackHead = player.b(atk.f);
            int levelHead = DynamicLights.getLightLevel(stackHead);
            int levelHandMax = Math.max(levelMain, levelOff);
            return Math.max(levelHandMax, levelHead);
        }
        if (entity instanceof bhc) {
            bhc entityItem = (bhc)entity;
            bqp itemStack = DynamicLights.getItemStack(entityItem);
            return DynamicLights.getLightLevel(itemStack);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLights(enf renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            for (int i2 = 0; i2 < dynamicLights.size(); ++i2) {
                DynamicLight dynamicLight = dynamicLights.get(i2);
                dynamicLight.updateLitChunks(renderGlobal);
            }
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            return mapDynamicLights.size();
        }
    }

    public static bqp getItemStack(bhc entityItem) {
        bqp itemstack = (bqp)entityItem.ad().a(PARAMETER_ITEM_STACK);
        return itemstack;
    }
}

