/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model.anim;

import net.optifine.expr.IExpressionBool;
import net.optifine.reflect.Reflector;
import net.optifine.util.BlockUtils;

public enum RenderEntityParameterBool implements IExpressionBool
{
    IS_ALIVE("is_alive"),
    IS_BURNING("is_burning"),
    IS_CHILD("is_child"),
    IS_GLOWING("is_glowing"),
    IS_HURT("is_hurt"),
    IS_IN_HAND("is_in_hand", true),
    IS_IN_GROUND("is_in_ground"),
    IS_IN_GUI("is_in_gui", true),
    IS_IN_LAVA("is_in_lava"),
    IS_IN_WATER("is_in_water", true),
    IS_INVISIBLE("is_invisible"),
    IS_ON_GROUND("is_on_ground"),
    IS_RIDDEN("is_ridden"),
    IS_RIDING("is_riding"),
    IS_SNEAKING("is_sneaking"),
    IS_SPRINTING("is_sprinting"),
    IS_WET("is_wet");

    private String name;
    private boolean blockEntity;
    private erv renderManager;
    private static final RenderEntityParameterBool[] VALUES;

    private RenderEntityParameterBool(String name) {
        this(name, false);
    }

    private RenderEntityParameterBool(String name, boolean blockEntity) {
        this.name = name;
        this.blockEntity = blockEntity;
        this.renderManager = dvo.C().ac();
    }

    public String getName() {
        return this.name;
    }

    public boolean isBlockEntity() {
        return this.blockEntity;
    }

    @Override
    public boolean eval() {
        atf entity;
        switch (this) {
            case IS_IN_HAND: {
                return end.isRenderItemHand();
            }
            case IS_IN_GUI: {
                return esu.isRenderItemGui();
            }
        }
        cip blockEntity = epd.tileEntityRendered;
        if (blockEntity != null) {
            switch (this) {
                case IS_IN_WATER: {
                    return BlockUtils.isPropertyTrue(blockEntity.n(), cli.C);
                }
            }
        }
        if ((entity = this.renderManager.renderEntity) == null) {
            return false;
        }
        if (entity instanceof att) {
            att livingEntity = (att)entity;
            switch (this) {
                case IS_CHILD: {
                    return livingEntity.w_();
                }
                case IS_HURT: {
                    return livingEntity.aK > 0;
                }
            }
        }
        if (entity instanceof bkh) {
            bkh arrowEntity = (bkh)entity;
            switch (this) {
                case IS_IN_GROUND: {
                    return Reflector.getFieldValueBoolean(arrowEntity, Reflector.AbstractArrow_inGround, false);
                }
            }
        }
        switch (this) {
            case IS_ALIVE: {
                return entity.bg();
            }
            case IS_BURNING: {
                return entity.bz();
            }
            case IS_GLOWING: {
                return entity.bN();
            }
            case IS_IN_LAVA: {
                return entity.aX();
            }
            case IS_IN_WATER: {
                return entity.aL();
            }
            case IS_INVISIBLE: {
                return entity.bP();
            }
            case IS_ON_GROUND: {
                return entity.ar();
            }
            case IS_RIDDEN: {
                return entity.bB();
            }
            case IS_RIDING: {
                return entity.bA();
            }
            case IS_SNEAKING: {
                return entity.bI();
            }
            case IS_SPRINTING: {
                return entity.bJ();
            }
            case IS_WET: {
                return entity.aM();
            }
        }
        return false;
    }

    public static RenderEntityParameterBool parse(String str) {
        if (str == null) {
            return null;
        }
        for (int i2 = 0; i2 < VALUES.length; ++i2) {
            RenderEntityParameterBool type = VALUES[i2];
            if (!type.getName().equals(str)) continue;
            return type;
        }
        return null;
    }

    static {
        VALUES = RenderEntityParameterBool.values();
    }
}

