/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.optifine.Config;
import net.optifine.model.BakedQuadRetextured;
import net.optifine.model.ModelUtils;

public class BlockModelUtils {
    private static final float VERTEX_COORD_ACCURACY = 1.0E-6f;
    private static final Random RANDOM = new Random(0L);

    public static eyx makeModelCube(String spriteName, int tintIndex) {
        exl sprite = Config.getTextureMap().getUploadedSprite(spriteName);
        return BlockModelUtils.makeModelCube(sprite, tintIndex);
    }

    public static eyx makeModelCube(exl sprite, int tintIndex) {
        ArrayList generalQuads = new ArrayList();
        gl[] facings = gl.o;
        HashMap faceQuads = new HashMap();
        for (int i2 = 0; i2 < facings.length; ++i2) {
            gl facing = facings[i2];
            ArrayList<eob> quads = new ArrayList<eob>();
            quads.add(BlockModelUtils.makeBakedQuad(facing, sprite, tintIndex));
            faceQuads.put(facing, quads);
        }
        eol itemOverrideList = eol.a;
        ezg bakedModel = new ezg(generalQuads, faceQuads, true, true, true, sprite, eon.a, itemOverrideList);
        return bakedModel;
    }

    public static eyx joinModelsCube(eyx modelBase, eyx modelAdd) {
        ArrayList generalQuads = new ArrayList();
        generalQuads.addAll(modelBase.a(null, null, RANDOM));
        generalQuads.addAll(modelAdd.a(null, null, RANDOM));
        gl[] facings = gl.o;
        HashMap faceQuads = new HashMap();
        for (int i2 = 0; i2 < facings.length; ++i2) {
            gl facing = facings[i2];
            ArrayList quads = new ArrayList();
            quads.addAll(modelBase.a(null, facing, RANDOM));
            quads.addAll(modelAdd.a(null, facing, RANDOM));
            faceQuads.put(facing, quads);
        }
        boolean ao = modelBase.a();
        boolean builtIn = modelBase.d();
        exl sprite = modelBase.e();
        eon transforms = modelBase.f();
        eol itemOverrideList = modelBase.g();
        ezg bakedModel = new ezg(generalQuads, faceQuads, ao, builtIn, true, sprite, transforms, itemOverrideList);
        return bakedModel;
    }

    public static eob makeBakedQuad(gl facing, exl sprite, int tintIndex) {
        k posFrom = new k(0.0f, 0.0f, 0.0f);
        k posTo = new k(16.0f, 16.0f, 16.0f);
        eof uv = new eof(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        eod face = new eod(facing, tintIndex, "#" + facing.c(), uv);
        eyy modelRotation = eyy.a;
        eoe partRotation = null;
        boolean shade = true;
        ww modelLoc = sprite.l();
        eoi faceBakery = new eoi();
        eob quad = faceBakery.a(posFrom, posTo, face, sprite, facing, (eze)modelRotation, partRotation, shade, modelLoc);
        return quad;
    }

    public static eyx makeModel(String modelName, String spriteOldName, String spriteNewName) {
        exk textureMap = Config.getTextureMap();
        exl spriteOld = textureMap.getUploadedSprite(spriteOldName);
        exl spriteNew = textureMap.getUploadedSprite(spriteNewName);
        return BlockModelUtils.makeModel(modelName, spriteOld, spriteNew);
    }

    public static eyx makeModel(String modelName, exl spriteOld, exl spriteNew) {
        if (spriteOld == null || spriteNew == null) {
            return null;
        }
        ezc modelManager = Config.getModelManager();
        if (modelManager == null) {
            return null;
        }
        ezd mrl = new ezd(modelName, "");
        eyx model = modelManager.a(mrl);
        if (model == null || model == modelManager.a()) {
            return null;
        }
        eyx modelNew = ModelUtils.duplicateModel(model);
        gl[] faces = gl.o;
        for (int i2 = 0; i2 < faces.length; ++i2) {
            gl face = faces[i2];
            List quads = modelNew.a(null, face, RANDOM);
            BlockModelUtils.replaceTexture(quads, spriteOld, spriteNew);
        }
        List quadsGeneral = modelNew.a(null, null, RANDOM);
        BlockModelUtils.replaceTexture(quadsGeneral, spriteOld, spriteNew);
        return modelNew;
    }

    private static void replaceTexture(List<eob> quads, exl spriteOld, exl spriteNew) {
        ArrayList<eob> quadsNew = new ArrayList<eob>();
        for (eob quad : quads) {
            if (quad.a() == spriteOld) {
                quad = new BakedQuadRetextured(quad, spriteNew);
            }
            quadsNew.add(quad);
        }
        quads.clear();
        quads.addAll(quadsNew);
    }

    public static void snapVertexPosition(k pos) {
        pos.b(BlockModelUtils.snapVertexCoord(pos.a()), BlockModelUtils.snapVertexCoord(pos.b()), BlockModelUtils.snapVertexCoord(pos.c()));
    }

    private static float snapVertexCoord(float x) {
        if (x > -1.0E-6f && x < 1.0E-6f) {
            return 0.0f;
        }
        if (x > 0.999999f && x < 1.000001f) {
            return 1.0f;
        }
        return x;
    }

    public static dmv getOffsetBoundingBox(dmv aabb, ckr.b offsetType, gg pos) {
        int x = pos.u();
        int z = pos.w();
        long k2 = (long)(x * 3129871) ^ (long)z * 116129781L;
        k2 = k2 * k2 * 42317861L + k2 * 11L;
        double dx = ((double)((float)(k2 >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dz = ((double)((float)(k2 >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dy = 0.0;
        if (offsetType == ckr.b.c) {
            dy = ((double)((float)(k2 >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        }
        return aabb.d(dx, dy, dz);
    }
}

