/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.reflect;

import java.lang.reflect.Field;
import net.optifine.Log;
import net.optifine.reflect.IFieldLocator;
import net.optifine.reflect.ReflectorClass;

public class FieldLocatorName
implements IFieldLocator {
    private ReflectorClass reflectorClass = null;
    private String targetFieldName = null;

    public FieldLocatorName(ReflectorClass reflectorClass, String targetFieldName) {
        this.reflectorClass = reflectorClass;
        this.targetFieldName = targetFieldName;
    }

    @Override
    public Field getField() {
        Class cls2 = this.reflectorClass.getTargetClass();
        if (cls2 == null) {
            return null;
        }
        try {
            Field targetField = this.getDeclaredField(cls2, this.targetFieldName);
            targetField.setAccessible(true);
            return targetField;
        }
        catch (NoSuchFieldException e2) {
            Log.log("(Reflector) Field not present: " + cls2.getName() + "." + this.targetFieldName);
            return null;
        }
        catch (SecurityException e3) {
            e3.printStackTrace();
            return null;
        }
        catch (Throwable e4) {
            e4.printStackTrace();
            return null;
        }
    }

    private Field getDeclaredField(Class cls2, String name) throws NoSuchFieldException {
        Field[] fields = cls2.getDeclaredFields();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            Field field = fields[i2];
            if (!field.getName().equals(name)) continue;
            return field;
        }
        if (cls2 == Object.class) {
            throw new NoSuchFieldException(name);
        }
        return this.getDeclaredField(cls2.getSuperclass(), name);
    }
}

