/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;

public class ChunkVisibility {
    public static final int MASK_FACINGS = 63;
    public static final gl[][] enumFacingArrays = ChunkVisibility.makeEnumFacingArrays(false);
    public static final gl[][] enumFacingOppositeArrays = ChunkVisibility.makeEnumFacingArrays(true);
    private static int counter = 0;
    private static int iMaxStatic = -1;
    private static int iMaxStaticFinal = 16;
    private static ejh worldLast = null;
    private static int pcxLast = Integer.MIN_VALUE;
    private static int pczLast = Integer.MIN_VALUE;

    public static int getMaxChunkY(ejh world, atf viewEntity, int renderDistanceChunks) {
        int minHeight = world.s_();
        int maxHeight = world.t_();
        int minChunkHeight = minHeight >> 4;
        int pcx = aha.b((double)viewEntity.cX()) >> 4;
        int pcy = aha.b((double)(viewEntity.cZ() - (double)minHeight)) >> 4;
        int pcz = aha.b((double)viewEntity.dd()) >> 4;
        int pcyMax = maxHeight - minHeight >> 4;
        pcy = Config.limit(pcy, 0, pcyMax - 1);
        long playerSectionKey = gz.c((gg)viewEntity.cR());
        cog playerSection = world.getEntityStorage().getSectionStorage().d(playerSectionKey);
        int cxStart = pcx - renderDistanceChunks;
        int cxEnd = pcx + renderDistanceChunks;
        int czStart = pcz - renderDistanceChunks;
        int czEnd = pcz + renderDistanceChunks;
        if (world != worldLast || pcx != pcxLast || pcz != pczLast) {
            counter = 0;
            iMaxStaticFinal = 16;
            worldLast = world;
            pcxLast = pcx;
            pczLast = pcz;
        }
        if (counter == 0) {
            iMaxStatic = -1;
        }
        int iMax = iMaxStatic;
        switch (counter) {
            case 0: {
                cxEnd = pcx;
                czEnd = pcz;
                break;
            }
            case 1: {
                cxStart = pcx;
                czEnd = pcz;
                break;
            }
            case 2: {
                cxEnd = pcx;
                czStart = pcz;
                break;
            }
            case 3: {
                cxStart = pcx;
                czStart = pcz;
            }
        }
        for (int cx = cxStart; cx < cxEnd; ++cx) {
            for (int cz = czStart; cz < czEnd; ++cz) {
                cmw chunk = world.d(cx, cz);
                if (chunk.u()) continue;
                cmx[] ebss = chunk.d();
                for (int i2 = ebss.length - 1; i2 > iMax; --i2) {
                    cmx ebs = ebss[i2];
                    if (ebs == null || ebs.c()) continue;
                    if (i2 <= iMax) break;
                    iMax = i2;
                    break;
                }
                try {
                    Map mapTileEntities = chunk.z();
                    if (mapTileEntities.isEmpty()) continue;
                    Set keys = mapTileEntities.keySet();
                    for (gg pos : keys) {
                        int i3 = pos.v() - minHeight >> 4;
                        if (i3 <= iMax) continue;
                        iMax = i3;
                    }
                    continue;
                }
                catch (ConcurrentModificationException mapTileEntities) {
                    // empty catch block
                }
            }
        }
        if (counter == 0) {
            LongSet sectionKeys = world.getEntityStorage().getSectionStorage().getSectionKeys();
            LongIterator it = sectionKeys.iterator();
            while (it.hasNext()) {
                long sectionKey = it.nextLong();
                int sectionY = gz.c((long)sectionKey);
                int i4 = sectionY - minChunkHeight;
                if (sectionKey == playerSectionKey && i4 == pcy && playerSection != null && playerSection.getEntityList().size() == 1 || i4 <= iMax) continue;
                iMax = i4;
            }
        }
        if (counter < 3) {
            iMaxStatic = iMax;
            iMax = iMaxStaticFinal;
        } else {
            iMaxStaticFinal = iMax;
            iMaxStatic = -1;
        }
        counter = (counter + 1) % 4;
        return (iMax << 4) + minHeight;
    }

    public static boolean isFinished() {
        return counter == 0;
    }

    private static gl[][] makeEnumFacingArrays(boolean opposite) {
        int count = 64;
        gl[][] arrs = new gl[count][];
        for (int i2 = 0; i2 < count; ++i2) {
            ArrayList<gl> list = new ArrayList<gl>();
            for (int ix = 0; ix < gl.o.length; ++ix) {
                gl facing = gl.o[ix];
                gl facingMask = opposite ? facing.f() : facing;
                int mask = 1 << facingMask.ordinal();
                if ((i2 & mask) == 0) continue;
                list.add(facing);
            }
            gl[] fs = list.toArray(new gl[list.size()]);
            arrs[i2] = fs;
        }
        return arrs;
    }

    public static gl[] getFacingsNotOpposite(int setDisabled) {
        int index = ~setDisabled & 0x3F;
        return enumFacingOppositeArrays[index];
    }

    public static void reset() {
        worldLast = null;
    }
}

