/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.optifine.Config;
import net.optifine.shaders.Program;
import net.optifine.shaders.RenderStage;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.config.HeaderLine;
import net.optifine.shaders.config.HeaderLineFunction;
import net.optifine.shaders.config.HeaderLineText;
import net.optifine.shaders.config.HeaderLineVariable;
import net.optifine.shaders.config.ShaderPackParser;
import net.optifine.shaders.config.ShaderType;
import net.optifine.util.ArrayUtils;
import net.optifine.util.LineBuffer;
import net.optifine.util.StrUtils;

public class ShadersCompatibility {
    public static Pattern PATTERN_UNIFORM = Pattern.compile("(\\s*layout\\s*\\(.*\\)|)\\s*uniform\\s+\\w+\\s+(\\w+).*");
    public static Pattern PATTERN_IN = Pattern.compile("(\\s*layout\\s*\\(.*\\)|)\\s*in\\s+\\w+\\s+(\\w+).*");
    public static Pattern PATTERN_OUT = Pattern.compile("(\\s*layout\\s*\\(.*\\)|)\\s*out\\s+\\w+\\s+(\\w+).*");
    public static Pattern PATTERN_VARYING = Pattern.compile("\\s*varying\\s+\\w+\\s+(\\w+).*");
    public static Pattern PATTERN_CONST = Pattern.compile("\\s*const\\s+\\w+\\s+(\\w+).*");
    public static Pattern PATTERN_FUNCTION = Pattern.compile("\\s*\\w+\\s+(\\w+)\\s*\\(.*\\).*", 32);
    public static HeaderLine MODEL_VIEW_MATRIX = ShadersCompatibility.makeHeaderLine("uniform mat4 modelViewMatrix;");
    public static HeaderLine PROJECTION_MATRIX = ShadersCompatibility.makeHeaderLine("uniform mat4 projectionMatrix;");
    public static HeaderLine TEXTURE_MATRIX = ShadersCompatibility.makeHeaderLine("uniform mat4 textureMatrix = mat4(1.0);");
    public static HeaderLine NORMAL_MATRIX = ShadersCompatibility.makeHeaderLine("uniform mat3 normalMatrix;");
    public static HeaderLine CHUNK_OFFSET = ShadersCompatibility.makeHeaderLine("uniform vec3 chunkOffset;");
    public static HeaderLine ALPHA_TEST_REF = ShadersCompatibility.makeHeaderLine("uniform float alphaTestRef;");
    public static HeaderLine TEXTURE_MATRIX_2 = ShadersCompatibility.makeHeaderLine("const mat4 TEXTURE_MATRIX_2 = mat4(vec4(0.00390625, 0.0, 0.0, 0.0), vec4(0.0, 0.00390625, 0.0, 0.0), vec4(0.0, 0.0, 0.00390625, 0.0), vec4(0.03125, 0.03125, 0.03125, 1.0));");
    public static HeaderLine FTRANSORM_BASIC = ShadersCompatibility.makeHeaderLine(ShadersCompatibility.makeFtransformBasic());
    public static HeaderLine SKY_COLOR = ShadersCompatibility.makeHeaderLine("uniform vec3 skyColor;");
    public static HeaderLine FOG_MODE = ShadersCompatibility.makeHeaderLine("uniform int fogMode;");
    public static HeaderLine FOG_DENSITY = ShadersCompatibility.makeHeaderLine("uniform float fogDensity;");
    public static HeaderLine FOG_START = ShadersCompatibility.makeHeaderLine("uniform float fogStart;");
    public static HeaderLine FOG_END = ShadersCompatibility.makeHeaderLine("uniform float fogEnd;");
    public static HeaderLine FOG_COLOR = ShadersCompatibility.makeHeaderLine("uniform vec3 fogColor;");
    public static HeaderLine VIEW_WIDTH = ShadersCompatibility.makeHeaderLine("uniform float viewWidth;");
    public static HeaderLine VIEW_HEIGHT = ShadersCompatibility.makeHeaderLine("uniform float viewHeight;");
    public static HeaderLine RENDER_STAGE = ShadersCompatibility.makeHeaderLine("uniform int renderStage;");
    public static HeaderLine FOG_FRAG_COORD_OUT = ShadersCompatibility.makeHeaderLine("out float vFogFragCoord;");
    public static HeaderLine FOG_FRAG_COORD_IN = ShadersCompatibility.makeHeaderLine("in float vFogFragCoord;");
    public static HeaderLine POSITION = ShadersCompatibility.makeHeaderLine("in vec3 Position;");
    public static HeaderLine COLOR = ShadersCompatibility.makeHeaderLine("in vec4 Color;");
    public static HeaderLine UV0 = ShadersCompatibility.makeHeaderLine("in vec2 UV0;");
    public static HeaderLine UV1 = ShadersCompatibility.makeHeaderLine("in ivec2 UV1;");
    public static HeaderLine UV2 = ShadersCompatibility.makeHeaderLine("in ivec2 UV2;");
    public static HeaderLine NORMAL = ShadersCompatibility.makeHeaderLine("in vec3 Normal;");
    private static final Pattern PATTERN_VERSION = ShaderPackParser.PATTERN_VERSION;
    public static final Pattern PATTERN_EXTENSION = Pattern.compile("\\s*#\\s*extension\\s+(\\w+)(.*)");
    public static final Pattern PATTERN_LINE = Pattern.compile("\\s*#\\s*line\\s+(\\d+)\\s+(\\d+)(.*)");
    private static final Pattern PATTERN_TEXTURE2D_TEXCOORD = Pattern.compile("(.*texture(2D)?\\s*\\(\\s*(texture|colortex0)\\s*,\\s*)(\\w+)(\\s*\\).*)");
    private static final Pattern PATTERN_FRAG_DATA_SET = Pattern.compile("(\\s*)gl_FragData\\[(\\d+)\\](\\S*)\\s*=\\s*(.*)");
    private static final Pattern PATTERN_FRAG_DATA = Pattern.compile("gl_FragData\\[(\\d+)\\]([^ ][^=])");
    private static final String COMMENT_COMPATIBILITY = "// Compatibility";

    public static LineBuffer remap(Program program, ShaderType shaderType, LineBuffer lines) {
        if (program == null) {
            return lines;
        }
        if (program.getProgramStage().isAnyComposite()) {
            return lines;
        }
        int version = 120;
        LineBuffer writer = new LineBuffer();
        LinkedHashSet<HeaderLine> headerLines = new LinkedHashSet<HeaderLine>();
        for (String line : lines) {
            if (line.equals(COMMENT_COMPATIBILITY)) {
                return lines;
            }
            if (line.trim().startsWith("//")) {
                writer.add(line);
                continue;
            }
            line = ShadersCompatibility.replace(line, "#version 110", "#version 130", headerLines, new HeaderLine[0]);
            line = ShadersCompatibility.replace(line, "#version 120", "#version 130", headerLines, new HeaderLine[0]);
            version = ShadersCompatibility.getVersion(line, version);
            if (shaderType == ShaderType.VERTEX) {
                line = program == Shaders.ProgramBasic && shaderType == ShaderType.VERTEX ? ShadersCompatibility.replace(line, "ftransform()", "ftransformBasic()", headerLines, RENDER_STAGE, VIEW_WIDTH, VIEW_HEIGHT, PROJECTION_MATRIX, MODEL_VIEW_MATRIX, POSITION, NORMAL, FTRANSORM_BASIC) : ShadersCompatibility.replace(line, "ftransform()", "(projectionMatrix * modelViewMatrix * vec4(Position + chunkOffset, 1.0))", headerLines, PROJECTION_MATRIX, MODEL_VIEW_MATRIX, POSITION, CHUNK_OFFSET);
                line = ShadersCompatibility.replace(line, "gl_Vertex", "vec4(Position + chunkOffset, 1.0)", headerLines, POSITION, CHUNK_OFFSET);
                line = program == Shaders.ProgramSkyTextured ? ShadersCompatibility.replace(line, "gl_Color", "vec4(1.0, 1.0, 1.0, 1.0)", headerLines, new HeaderLine[0]) : (program == Shaders.ProgramSkyBasic ? ShadersCompatibility.replace(line, "gl_Color", "vec4(skyColor, 1.0)", headerLines, SKY_COLOR) : ShadersCompatibility.replace(line, "gl_Color", "Color", headerLines, COLOR));
                line = ShadersCompatibility.replace(line, "gl_Normal", "Normal", headerLines, NORMAL);
                line = ShadersCompatibility.replace(line, "gl_MultiTexCoord0", "vec4(UV0, 0.0, 1.0)", headerLines, UV0);
                line = ShadersCompatibility.replace(line, "gl_MultiTexCoord1", "vec4(UV1, 0.0, 1.0)", headerLines, UV1);
                line = ShadersCompatibility.replace(line, "gl_MultiTexCoord2", "vec4(UV2, 0.0, 1.0)", headerLines, UV2);
                line = ShadersCompatibility.replace(line, "gl_MultiTexCoord3", "vec4(0.0, 0.0, 0.0, 1.0)", headerLines, new HeaderLine[0]);
            }
            line = ShadersCompatibility.replace(line, "gl_ProjectionMatrix", "projectionMatrix", headerLines, PROJECTION_MATRIX);
            line = ShadersCompatibility.replace(line, "gl_ModelViewMatrix", "modelViewMatrix", headerLines, MODEL_VIEW_MATRIX);
            line = ShadersCompatibility.replace(line, "gl_ModelViewProjectionMatrix", "(projectionMatrix * modelViewMatrix)", headerLines, PROJECTION_MATRIX, MODEL_VIEW_MATRIX);
            line = ShadersCompatibility.replace(line, "gl_NormalMatrix", "normalMatrix", headerLines, NORMAL_MATRIX);
            if (shaderType == ShaderType.VERTEX) {
                line = ShadersCompatibility.replace(line, "varying", "out", headerLines, new HeaderLine[0]);
            }
            if (shaderType == ShaderType.FRAGMENT) {
                line = ShadersCompatibility.replace(line, "varying", "in", headerLines, new HeaderLine[0]);
            }
            line = ShadersCompatibility.replace(line, "gl_TextureMatrix[0]", "textureMatrix", headerLines, TEXTURE_MATRIX);
            line = ShadersCompatibility.replace(line, "gl_TextureMatrix[1]", "mat4(1.0)", headerLines, new HeaderLine[0]);
            line = ShadersCompatibility.replace(line, "gl_TextureMatrix[2]", "TEXTURE_MATRIX_2", headerLines, TEXTURE_MATRIX_2);
            if (shaderType == ShaderType.VERTEX) {
                line = ShadersCompatibility.replace(line, "gl_FogFragCoord", "vFogFragCoord", headerLines, FOG_FRAG_COORD_OUT);
            }
            if (shaderType == ShaderType.FRAGMENT) {
                line = ShadersCompatibility.replace(line, "gl_FogFragCoord", "vFogFragCoord", headerLines, FOG_FRAG_COORD_IN);
            }
            line = ShadersCompatibility.replace(line, "gl_Fog.density", "fogDensity", headerLines, FOG_DENSITY);
            line = ShadersCompatibility.replace(line, "gl_Fog.start", "fogStart", headerLines, FOG_START);
            line = ShadersCompatibility.replace(line, "gl_Fog.end", "fogEnd", headerLines, FOG_END);
            line = ShadersCompatibility.replace(line, "gl_Fog.scale", "(1.0 / (fogEnd - fogStart))", headerLines, FOG_START, FOG_END);
            line = ShadersCompatibility.replace(line, "gl_Fog.color", "vec4(fogColor, 1.0)", headerLines, FOG_COLOR);
            if (program.getName().contains("entities")) {
                line = ShadersCompatibility.replace(line, PATTERN_TEXTURE2D_TEXCOORD, "$1clamp($4, 0.0, 1.0)$5", headerLines, new HeaderLine[0]);
            }
            if (shaderType == ShaderType.FRAGMENT) {
                line = ShadersCompatibility.replace(line, "gl_FragColor", "gl_FragData[0]", headerLines, new HeaderLine[0]);
                line = ShadersCompatibility.addAlphaTest(program, line, headerLines);
            }
            line = ShadersCompatibility.replace(line, "gl_ModelViewMatrixInverse", "gl_ModelViewMatrixInverse_TODO", headerLines, new HeaderLine[0]);
            line = ShadersCompatibility.replace(line, "gl_ProjectionMatrixInverse", "gl_ProjectionMatrixInverse_TODO", headerLines, new HeaderLine[0]);
            line = ShadersCompatibility.replace(line, "gl_ModelViewProjectionMatrixInverse", "gl_ModelViewProjectionMatrixInverse_TODO", headerLines, new HeaderLine[0]);
            line = ShadersCompatibility.replace(line, "gl_TextureMatrixInverse", "gl_TextureMatrixInverse_TODO", headerLines, new HeaderLine[0]);
            line = ShadersCompatibility.replace(line, "gl_ModelViewMatrixTranspose", "gl_ModelViewMatrixTranspose_TODO", headerLines, new HeaderLine[0]);
            line = ShadersCompatibility.replace(line, "gl_ProjectionMatrixTranspose", "gl_ProjectionMatrixTranspose_TODO", headerLines, new HeaderLine[0]);
            line = ShadersCompatibility.replace(line, "gl_ModelViewProjectionMatrixTranspose", "gl_ModelViewProjectionMatrixTranspose_TODO", headerLines, new HeaderLine[0]);
            line = ShadersCompatibility.replace(line, "gl_TextureMatrixTranspose", "gl_TextureMatrixTranspose_TODO", headerLines, new HeaderLine[0]);
            line = ShadersCompatibility.replace(line, "gl_ModelViewMatrixInverseTranspose", "gl_ModelViewMatrixInverseTranspose_TODO", headerLines, new HeaderLine[0]);
            line = ShadersCompatibility.replace(line, "gl_ProjectionMatrixInverseTranspose", "gl_ProjectionMatrixInverseTranspose_TODO", headerLines, new HeaderLine[0]);
            line = ShadersCompatibility.replace(line, "gl_ModelViewProjectionMatrixInverseTranspose", "gl_ModelViewProjectionMatrixInverseTranspose_TODO", headerLines, new HeaderLine[0]);
            if ((line = ShadersCompatibility.replace(line, "gl_TextureMatrixInverseTranspose", "gl_TextureMatrixInverseTranspose_TODO", headerLines, new HeaderLine[0])).contains("\n")) {
                String[] parts = Config.tokenize(line, "\n\r");
                writer.add(parts);
                continue;
            }
            writer.add(line);
        }
        if (headerLines.isEmpty()) {
            return writer;
        }
        writer = ShadersCompatibility.removeExisting(headerLines, writer);
        Object[] newHeaderLinesArr = (String[])headerLines.stream().map(x -> x.getText()).toArray(String[]::new);
        Arrays.sort(newHeaderLinesArr, ShadersCompatibility.getComparatorHeaderLines());
        newHeaderLinesArr = (String[])ArrayUtils.addObjectToArray(newHeaderLinesArr, COMMENT_COMPATIBILITY, 0);
        int indexInsert = ShadersCompatibility.getIndexInsertHeader(lines, version);
        if (indexInsert >= 0) {
            writer.insert(indexInsert, (String[])newHeaderLinesArr);
        }
        return writer;
    }

    private static HeaderLine makeHeaderLine(String line) {
        Matcher mu = PATTERN_UNIFORM.matcher(line);
        if (mu.matches()) {
            return new HeaderLineVariable("uniform", mu.group(2), line);
        }
        Matcher mi = PATTERN_IN.matcher(line);
        if (mi.matches()) {
            return new HeaderLineVariable("in", mi.group(2), line);
        }
        Matcher mo = PATTERN_OUT.matcher(line);
        if (mo.matches()) {
            return new HeaderLineVariable("out", mo.group(2), line);
        }
        Matcher mv = PATTERN_VARYING.matcher(line);
        if (mv.matches()) {
            return new HeaderLineVariable("varying", mv.group(1), line);
        }
        Matcher mc = PATTERN_CONST.matcher(line);
        if (mc.matches()) {
            return new HeaderLineVariable("const", mc.group(1), line);
        }
        Matcher mf = PATTERN_FUNCTION.matcher(line);
        if (mf.matches()) {
            return new HeaderLineFunction(mf.group(1), line);
        }
        throw new IllegalArgumentException("Unknown header line: " + line);
    }

    private static String makeFtransformBasic() {
        StringBuilder buf = new StringBuilder();
        ShadersCompatibility.addLine(buf, "vec4 ftransformBasic()                                                                                 ");
        ShadersCompatibility.addLine(buf, "{                                                                                                      ");
        ShadersCompatibility.addLine(buf, "  if(renderStage != MC_RENDER_STAGE_OUTLINE)   // Render stage outline                                 ");
        ShadersCompatibility.addLine(buf, "    return projectionMatrix * modelViewMatrix * vec4(Position, 1.0);                                   ");
        ShadersCompatibility.addLine(buf, "  float lineWidth = 2.5;                                                                               ");
        ShadersCompatibility.addLine(buf, "  vec2 screenSize = vec2(viewWidth, viewHeight);                                                       ");
        ShadersCompatibility.addLine(buf, "  const mat4 VIEW_SCALE = mat4(mat3(1.0 - (1.0 / 256.0)));                                             ");
        ShadersCompatibility.addLine(buf, "  vec4 linePosStart = projectionMatrix * VIEW_SCALE * modelViewMatrix * vec4(Position, 1.0);           ");
        ShadersCompatibility.addLine(buf, "  vec4 linePosEnd = projectionMatrix * VIEW_SCALE * modelViewMatrix * (vec4(Position + Normal, 1.0));  ");
        ShadersCompatibility.addLine(buf, "  vec3 ndc1 = linePosStart.xyz / linePosStart.w;                                                       ");
        ShadersCompatibility.addLine(buf, "  vec3 ndc2 = linePosEnd.xyz / linePosEnd.w;                                                           ");
        ShadersCompatibility.addLine(buf, "  vec2 lineScreenDirection = normalize((ndc2.xy - ndc1.xy) * screenSize);                              ");
        ShadersCompatibility.addLine(buf, "  vec2 lineOffset = vec2(-lineScreenDirection.y, lineScreenDirection.x) * lineWidth / screenSize;      ");
        ShadersCompatibility.addLine(buf, "  if (lineOffset.x < 0.0)                                                                              ");
        ShadersCompatibility.addLine(buf, "    lineOffset *= -1.0;                                                                                ");
        ShadersCompatibility.addLine(buf, "  if (gl_VertexID % 2 == 0)                                                                            ");
        ShadersCompatibility.addLine(buf, "    return vec4((ndc1 + vec3(lineOffset, 0.0)) * linePosStart.w, linePosStart.w);                      ");
        ShadersCompatibility.addLine(buf, "  else                                                                                                 ");
        ShadersCompatibility.addLine(buf, "    return vec4((ndc1 - vec3(lineOffset, 0.0)) * linePosStart.w, linePosStart.w);                      ");
        ShadersCompatibility.addLine(buf, "}                                                                                                      ");
        String src = buf.toString();
        src = src.replace("MC_RENDER_STAGE_OUTLINE", "" + RenderStage.OUTLINE.ordinal());
        return src;
    }

    private static void addLine(StringBuilder buf, String line) {
        buf.append(StrUtils.trimTrailing(line, " \t") + "\n");
    }

    private static LineBuffer removeExisting(Set<HeaderLine> headerLines, LineBuffer lines) {
        if (headerLines.isEmpty()) {
            return lines;
        }
        LineBuffer linesNew = new LineBuffer(lines.getLines());
        for (HeaderLine headerLine : headerLines) {
            for (int i2 = 0; i2 < linesNew.size(); ++i2) {
                String lineNew = linesNew.get(i2);
                if (!headerLine.matches(lineNew)) continue;
                String lineNew2 = headerLine.removeFrom(lineNew);
                if (lineNew2 != null) {
                    linesNew.set(i2, lineNew2);
                    continue;
                }
                linesNew.remove(i2);
                --i2;
            }
        }
        return linesNew;
    }

    private static int getVersion(String line, int def) {
        Matcher m = PATTERN_VERSION.matcher(line);
        if (!m.matches()) {
            return def;
        }
        String verStr = m.group(1);
        int ver = Config.parseInt(verStr, -1);
        if (ver < def) {
            return def;
        }
        return ver;
    }

    private static int getIndexInsertHeader(LineBuffer lines, int version) {
        int indexLine;
        int indexVersion = lines.indexMatch(PATTERN_VERSION);
        int indexInsert = indexLine = lines.indexMatch(PATTERN_LINE, indexVersion);
        if (version >= 440) {
            int indexLastExtension = lines.lastIndexMatch(PATTERN_EXTENSION);
            indexInsert = Math.max(indexInsert, indexLastExtension + 1);
        }
        if (indexInsert < 0) {
            Config.warn("Header insert line not found");
        }
        return indexInsert;
    }

    private static String addAlphaTest(Program program, String line, Set<HeaderLine> headerLines) {
        Matcher m2;
        if (program.getProgramStage().isAnyComposite()) {
            return line;
        }
        Matcher m = PATTERN_FRAG_DATA_SET.matcher(line);
        if (m.matches()) {
            String line2;
            String index = m.group(2);
            if (!index.equals("0")) {
                return line;
            }
            HeaderLineText hl = new HeaderLineText("vec4 temp_FragData" + index + ";");
            headerLines.add(hl);
            headerLines.add(ALPHA_TEST_REF);
            line = line2 = m.replaceAll("$1{\n$1  temp_FragData$2$3 = $4\n$1  if(temp_FragData$2.a < alphaTestRef) discard;\n$1  gl_FragData[$2] = temp_FragData$2;\n$1}");
        }
        if ((m2 = PATTERN_FRAG_DATA.matcher(line)).find()) {
            String line2;
            String index = m2.group(1);
            if (!index.equals("0")) {
                return line;
            }
            HeaderLineText hl = new HeaderLineText("vec4 temp_FragData" + index + ";");
            headerLines.add(hl);
            line = line2 = m2.replaceAll("temp_FragData$1$2");
        }
        return line;
    }

    private static Comparator<String> getComparatorHeaderLines() {
        Comparator<String> comp = new Comparator<String>(){
            private static final int UNKNOWN = Integer.MAX_VALUE;

            @Override
            public int compare(String o1, String o2) {
                int i1 = this.getIndex(o1);
                int i2 = this.getIndex(o2);
                if (i1 == Integer.MAX_VALUE && i2 == Integer.MAX_VALUE) {
                    return o1.compareTo(o2);
                }
                return i1 - i2;
            }

            private int getIndex(String line) {
                if (line.equals(MODEL_VIEW_MATRIX)) {
                    return 0;
                }
                if (line.equals(PROJECTION_MATRIX)) {
                    return 1;
                }
                if (line.equals(TEXTURE_MATRIX)) {
                    return 2;
                }
                if (line.equals(CHUNK_OFFSET)) {
                    return 3;
                }
                if (line.equals(POSITION)) {
                    return 10;
                }
                if (line.equals(COLOR)) {
                    return 11;
                }
                if (line.equals(UV0)) {
                    return 12;
                }
                if (line.equals(UV1)) {
                    return 13;
                }
                if (line.equals(UV2)) {
                    return 14;
                }
                if (line.equals(NORMAL)) {
                    return 15;
                }
                return Integer.MAX_VALUE;
            }
        };
        return comp;
    }

    private static String replace(String line, String find, String replace, Set<HeaderLine> newLines, HeaderLine ... headerLines) {
        String line2 = ShadersCompatibility.replaceWord(line, find, replace);
        if (!line2.equals(line) && headerLines.length > 0) {
            newLines.addAll(Arrays.asList(headerLines));
        }
        return line2;
    }

    private static String replaceWord(String line, String find, String replace) {
        String line2 = line;
        int pos = line2.length();
        while (pos > 0) {
            char charNext;
            char charPrev;
            if ((pos = line2.lastIndexOf(find, pos - 1)) < 0) continue;
            int posEnd = pos + find.length();
            if (pos - 1 >= 0 && (Character.isLetter(charPrev = line2.charAt(pos - 1)) || Character.isDigit(charPrev) || charPrev == '_') || posEnd < line2.length() && (Character.isLetter(charNext = line2.charAt(posEnd)) || Character.isDigit(charNext) || charNext == '_')) continue;
            line2 = line2.substring(0, pos) + replace + line2.substring(posEnd);
        }
        return line2;
    }

    private static String replace(String line, Pattern pattern, String replace, Set<HeaderLine> newLines, HeaderLine ... headerLines) {
        Matcher m = pattern.matcher(line);
        if (!m.matches()) {
            return line;
        }
        String line2 = m.replaceAll(replace);
        if (!line2.equals(line) && headerLines.length > 0) {
            newLines.addAll(Arrays.asList(headerLines));
        }
        return line2;
    }
}

